/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.samples.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.AbsSavedState;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.Arrays;
import java.util.List;
import universum.studios.android.samples.ui.widget.SamplesDataSetAdapter;
import universum.studios.android.samples.ui.widget.SamplesOnDataSetActionListener;
import universum.studios.android.samples.ui.widget.SamplesOnDataSetListener;

public abstract class SamplesRecyclerAdapter<Item, VH extends RecyclerView.ViewHolder>
extends RecyclerView.Adapter<VH>
implements SamplesDataSetAdapter<Item> {
    protected final Context mContext;
    protected final LayoutInflater mLayoutInflater;
    protected final Resources mResources;
    private SamplesOnDataSetListener mDataSetListener;
    private SamplesOnDataSetActionListener mDataSetActionListener;
    private List<Item> mItems;

    public SamplesRecyclerAdapter(@NonNull Context context, @NonNull Item[] items) {
        this(context, Arrays.asList(items));
    }

    public SamplesRecyclerAdapter(@NonNull Context context, @NonNull List<Item> items) {
        this(context);
        this.mItems = items;
    }

    public SamplesRecyclerAdapter(@NonNull Context context) {
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mResources = context.getResources();
    }

    @Nullable
    public List<Item> getItems() {
        return this.mItems;
    }

    @Nullable
    public List<Item> swapItems(@Nullable List<Item> items) {
        List<Item> oldItems = this.mItems;
        this.changeItems(items);
        return oldItems;
    }

    public void changeItems(@Nullable List<Item> items) {
        this.mItems = items;
        this.notifyDataSetChanged();
    }

    public void changeItems(@NonNull Item[] items) {
        this.changeItems(Arrays.asList(items));
    }

    public void clearItems() {
        if (this.mItems != null) {
            this.mItems.clear();
            this.notifyDataSetChanged();
        }
    }

    @Override
    public int getItemCount() {
        return this.mItems != null ? this.mItems.size() : 0;
    }

    @Override
    @NonNull
    public Item getItem(int position) {
        int itemsCount = this.getItemCount();
        if (position < 0 || position >= itemsCount) {
            throw new IndexOutOfBoundsException("Requested item at invalid position(" + position + "). " + "Current data set is in size of(" + itemsCount + ") items.");
        }
        return this.mItems.get(position);
    }

    @Override
    @NonNull
    public Parcelable saveInstanceState() {
        return this.onSaveInstanceState();
    }

    @NonNull
    @CallSuper
    protected Parcelable onSaveInstanceState() {
        return AbsSavedState.EMPTY_STATE;
    }

    @Override
    public void restoreInstanceState(@NonNull Parcelable savedState) {
        this.onRestoreInstanceState(savedState);
    }

    @CallSuper
    protected void onRestoreInstanceState(@NonNull Parcelable savedState) {
    }

    @Override
    public void setOnDataSetListener(@Nullable SamplesOnDataSetListener listener) {
        this.mDataSetListener = listener;
    }

    @Override
    public void setOnDataSetActionListener(@Nullable SamplesOnDataSetActionListener listener) {
        this.mDataSetActionListener = listener;
    }

    @Override
    public void notifyDataSetInvalidated() {
        if (this.mDataSetListener != null) {
            this.mDataSetListener.onDataSetInvalidated(this);
        }
    }

    protected boolean notifyDataSetActionSelected(int action, int position, @Nullable Object data) {
        if (position < 0 || position >= this.getItemCount()) {
            return false;
        }
        return this.onDataSetActionSelected(action, position, data) || this.mDataSetActionListener != null && this.mDataSetActionListener.onDataSetActionSelected(this, action, position, this.getItemId(position), data);
    }

    protected boolean onDataSetActionSelected(int action, int position, @Nullable Object data) {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    @Override
    public boolean hasItem(int position) {
        return position >= 0 && position < this.getItemCount();
    }

    @Override
    public long getItemId(int position) {
        if (!this.hasStableIds()) {
            return -1L;
        }
        return position;
    }

    @Override
    public boolean isEnabled(int position) {
        return true;
    }

    public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    @NonNull
    protected final View inflate(@LayoutRes int resource, @NonNull ViewGroup parent) {
        return this.mLayoutInflater.inflate(resource, parent, false);
    }

    public abstract void onBindViewHolder(@NonNull VH var1, int var2);

    public static class SimpleViewHolder
    extends RecyclerView.ViewHolder {
        public SimpleViewHolder(@NonNull View itemView) {
            super(itemView);
        }
    }
}

