/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.samples.ui;

import android.app.Activity;
import android.app.Fragment;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.NavigationView;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import universum.studios.android.samples.R;
import universum.studios.android.samples.ui.SamplesActivity;
import universum.studios.android.samples.ui.SamplesMainFragment;

public abstract class SamplesNavigationActivity
extends SamplesActivity
implements NavigationView.OnNavigationItemSelectedListener {
    private DrawerLayout mDrawerLayout;
    private ActionBarDrawerToggle mDrawerToggle;
    private NavigationView mNavigationView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.requestFeature(3);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.samples_activity_navigation);
        if (savedInstanceState == null) {
            this.getFragmentManager().beginTransaction().add(R.id.samples_container, (Fragment)new SamplesMainFragment(), "universum.studios.android.samples.ui.SamplesMainFragment.TAG").commitAllowingStateLoss();
        }
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        this.mToolbar.setNavigationIcon((Drawable)VectorDrawableCompat.create((Resources)this.getResources(), (int)R.drawable.samples_vc_menu_24dp, (Resources.Theme)this.getTheme()));
        this.mDrawerLayout = (DrawerLayout)this.findViewById(R.id.samples_navigation_drawer);
        this.mDrawerToggle = new ActionBarDrawerToggle((Activity)this, this.mDrawerLayout, this.mToolbar, R.string.samples_content_navigation_opened, R.string.samples_content_navigation_closed){

            public void onDrawerOpened(View drawerView) {
                drawerView.bringToFront();
            }

            public void onDrawerClosed(View view) {
            }
        };
        this.mDrawerLayout.addDrawerListener((DrawerLayout.DrawerListener)this.mDrawerToggle);
        this.mNavigationView = (NavigationView)this.mDrawerLayout.findViewById(R.id.samples_navigation);
        int navigationMenuRes = 0;
        try {
            ActivityInfo activityInfo = this.getPackageManager().getActivityInfo(this.getComponentName(), 129);
            navigationMenuRes = activityInfo.metaData.getInt("universum.studios.android.samples.SamplesMetaData.NAVIGATION_MENU");
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        View navigationHeaderView = this.mNavigationView.getHeaderView(0);
        ((TextView)navigationHeaderView.findViewById(R.id.navigation_header_title)).setText(this.getApplicationInfo().labelRes);
        if (navigationMenuRes != 0) {
            this.mNavigationView.inflateMenu(navigationMenuRes);
            this.mNavigationView.setNavigationItemSelectedListener((NavigationView.OnNavigationItemSelectedListener)this);
        }
    }

    protected void openNavigation() {
        this.mDrawerLayout.openDrawer(3);
    }

    protected void closeNavigation() {
        this.mDrawerLayout.closeDrawer(3);
    }

    public boolean onNavigationItemSelected(@NonNull MenuItem item) {
        if (this.onHandleNavigationItemSelected(item)) {
            this.closeNavigation();
            return true;
        }
        return false;
    }

    protected boolean onHandleNavigationItemSelected(@NonNull MenuItem item) {
        return false;
    }
}

