/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.samples.ui;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import butterknife.ButterKnife;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.samples.R;

public class SamplesActivity
extends AppCompatActivity {
    protected static final int FEATURE_DEPENDENCIES_INJECTION = 1;
    protected static final int FEATURE_TOOLBAR = 2;
    private int mFeatures;
    Toolbar mToolbar;

    protected int requestFeature(int feature) {
        this.mFeatures |= feature;
        return this.mFeatures;
    }

    protected boolean hasFeature(int feature) {
        return (this.mFeatures & feature) == feature;
    }

    protected void removeFeature(int feature) {
        this.mFeatures &= ~feature;
    }

    public void onContentChanged() {
        super.onContentChanged();
        if (this.hasFeature(1)) {
            ButterKnife.bind((Activity)this);
        }
        if (this.hasFeature(2)) {
            this.mToolbar = (Toolbar)this.findViewById(R.id.samples_toolbar);
            if (this.mToolbar == null) {
                throw new NullPointerException("No toolbar found within the view hierarchy!");
            }
            this.setSupportActionBar(this.mToolbar);
        }
    }

    @NonNull
    public Toolbar getToolbar() {
        if (this.mToolbar == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " has no toolbar available!");
        }
        return this.mToolbar;
    }

    public void setTitle(@Nullable CharSequence title) {
        if (this.mToolbar != null) {
            this.mToolbar.setTitle(title);
        } else {
            super.setTitle(title);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    protected static @interface ActivityFeature {
    }
}

