/*
 * =================================================================================================
 *                             Copyright (C) 2016 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License 
 * you may obtain at
 * 
 * 		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * You can redistribute, modify or publish any part of the code written within this file but as it 
 * is described in the License, the software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.samples.ui;

import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.widget.NavigationView;
import android.support.graphics.drawable.VectorDrawableCompat;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;

import universum.studios.android.samples.R;
import universum.studios.android.samples.SamplesMetaData;

/**
 * todo: description
 *
 * @author Martin Albedinsky
 */
public abstract class SamplesNavigationActivity extends SamplesActivity
		implements
		NavigationView.OnNavigationItemSelectedListener {

	/**
	 * Interface ===================================================================================
	 */

	/**
	 * Constants ===================================================================================
	 */

	/**
	 * Log TAG.
	 */
	// private static final String TAG = "SamplesNavigationActivity";

	/**
	 * Static members ==============================================================================
	 */

	/**
	 * Members =====================================================================================
	 */

	/**
	 * todo
	 */
	private DrawerLayout mDrawerLayout;

	/**
	 * todo
	 */
	private ActionBarDrawerToggle mDrawerToggle;

	/**
	 * todo:
	 */
	private NavigationView mNavigationView;

	/**
	 * Constructors ================================================================================
	 */

	/**
	 * Methods =====================================================================================
	 */

	/**
	 */
	@Override
	protected void onCreate(@Nullable Bundle savedInstanceState) {
		requestFeature(FEATURE_DEPENDENCIES_INJECTION | FEATURE_TOOLBAR);
		super.onCreate(savedInstanceState);
		setContentView(R.layout.samples_activity_navigation);
	}

	/**
	 */
	@Override
	@SuppressWarnings({"ConstantConditions", "ResourceType"})
	public void onContentChanged() {
		super.onContentChanged();
		this.mToolbar.setNavigationIcon(VectorDrawableCompat.create(
				getResources(),
				R.drawable.samples_vc_menu,
				getTheme()
		));
		this.mDrawerLayout = (DrawerLayout) findViewById(R.id.samples_navigation_drawer);
		this.mDrawerToggle = new ActionBarDrawerToggle(
				this,
				mDrawerLayout,
				mToolbar,
				R.string.samples_content_navigation_opened,
				R.string.samples_content_navigation_closed)
		{

			/**
			 */
			@Override
			public void onDrawerOpened(View drawerView) {
				drawerView.bringToFront();
			}

			/**
			 */
			@Override
			public void onDrawerClosed(View view) {
			}
		};
		this.mDrawerLayout.addDrawerListener(mDrawerToggle);
		this.mNavigationView = (NavigationView) mDrawerLayout.findViewById(R.id.samples_navigation);
		int navigationMenuRes = 0;
		try {
			final ActivityInfo activityInfo = getPackageManager().getActivityInfo(getComponentName(), PackageManager.GET_ACTIVITIES | PackageManager.GET_META_DATA);
			navigationMenuRes = activityInfo.metaData.getInt(SamplesMetaData.NAVIGATION_MENU);
		} catch (PackageManager.NameNotFoundException e) {
			e.printStackTrace();
		}
		final View navigationHeaderView = mNavigationView.getHeaderView(0);
		((TextView) navigationHeaderView.findViewById(R.id.navigation_header_title)).setText(getApplicationInfo().labelRes);
		if (navigationMenuRes != 0) {
			mNavigationView.inflateMenu(navigationMenuRes);
			mNavigationView.setNavigationItemSelectedListener(this);
		}
	}

	/**
	 */
	@Override
	public boolean onNavigationItemSelected(@NonNull MenuItem item) {
		return false;
	}

	/**
	 * Inner classes ===============================================================================
	 */
}
