/*
 * =================================================================================================
 *                             Copyright (C) 2016 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License 
 * you may obtain at
 * 
 * 		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * You can redistribute, modify or publish any part of the code written within this file but as it 
 * is described in the License, the software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.samples.ui;

import android.app.Fragment;
import android.os.Bundle;
import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import butterknife.ButterKnife;

/**
 * todo: description
 *
 * @author Martin Albedinsky
 */
public class SamplesFragment extends Fragment {

	/**
	 * Interface ===================================================================================
	 */

	/**
	 * Constants ===================================================================================
	 */

	/**
	 * Log TAG.
	 */
	// private static final String TAG = "SamplesFragment";

	/**
	 * todo
	 */
	@IntDef(flag = true, value = {
			FEATURE_DEPENDENCIES_INJECTION
	})
	@Retention(RetentionPolicy.SOURCE)
	protected @interface FragmentFeature {
	}

	/**
	 * todo:
	 */
	protected static final int FEATURE_DEPENDENCIES_INJECTION = 0x00000001;

	/**
	 * Static members ==============================================================================
	 */

	/**
	 * Members =====================================================================================
	 */

	/**
	 * todo:
	 */
	private int mFeatures;

	/**
	 * Constructors ================================================================================
	 */

	/**
	 * Methods =====================================================================================
	 */

	/**
	 * todo:
	 *
	 * @param feature
	 * @return
	 */
	@FragmentFeature
	protected int requestFeature(@FragmentFeature int feature) {
		this.mFeatures |= feature;
		return mFeatures;
	}

	/**
	 * todo:
	 *
	 * @param feature
	 * @return
	 */
	protected boolean hasFeature(@FragmentFeature int feature) {
		return (mFeatures & feature) == feature;
	}

	/**
	 * todo:
	 *
	 * @param feature
	 */
	protected void removeFeature(@FragmentFeature int feature) {
		this.mFeatures &= ~feature;
	}

	/**
	 */
	@Override
	public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
		super.onViewCreated(view, savedInstanceState);
		if (hasFeature(FEATURE_DEPENDENCIES_INJECTION)) {
			ButterKnife.bind(this, view);
		}
	}

	/**
	 * Inner classes ===============================================================================
	 */
}
