/*
 * =================================================================================================
 *                             Copyright (C) 2016 Universum Studios
 * =================================================================================================
 *         Licensed under the Apache License, Version 2.0 or later (further "License" only).
 * -------------------------------------------------------------------------------------------------
 * You may use this file only in compliance with the License. More details and copy of this License 
 * you may obtain at
 * 
 * 		http://www.apache.org/licenses/LICENSE-2.0
 * 
 * You can redistribute, modify or publish any part of the code written within this file but as it 
 * is described in the License, the software distributed under the License is distributed on an 
 * "AS IS" BASIS, WITHOUT WARRANTIES or CONDITIONS OF ANY KIND.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 * =================================================================================================
 */
package universum.studios.android.samples.ui;

import android.support.annotation.IntDef;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

import butterknife.ButterKnife;
import universum.studios.android.samples.R;

/**
 * todo: description
 *
 * @author Martin Albedinsky
 */
public class SamplesActivity extends AppCompatActivity {

	/**
	 * Interface ===================================================================================
	 */

	/**
	 * Constants ===================================================================================
	 */

	/**
	 * Log TAG.
	 */
	// private static final String TAG = "SamplesActivity";

	/**
	 * todo
	 */
	@IntDef(flag = true, value = {
			FEATURE_DEPENDENCIES_INJECTION,
			FEATURE_TOOLBAR
	})
	@Retention(RetentionPolicy.SOURCE)
	protected @interface ActivityFeature {
	}

	/**
	 * todo:
	 */
	protected static final int FEATURE_DEPENDENCIES_INJECTION = 0x00000001;

	/**
	 * todo:
	 */
	protected static final int FEATURE_TOOLBAR = 0x00000001 << 1;

	/**
	 * Static members ==============================================================================
	 */

	/**
	 * Members =====================================================================================
	 */

	/**
	 * todo:
	 */
	private int mFeatures;

	/**
	 * todo
	 */
	Toolbar mToolbar;

	/**
	 * Constructors ================================================================================
	 */

	/**
	 * Methods =====================================================================================
	 */

	/**
	 * todo:
	 *
	 * @param feature
	 * @return
	 */
	@ActivityFeature
	protected int requestFeature(@ActivityFeature int feature) {
		this.mFeatures |= feature;
		return mFeatures;
	}

	/**
	 * todo:
	 *
	 * @param feature
	 * @return
	 */
	protected boolean hasFeature(@ActivityFeature int feature) {
		return (mFeatures & feature) == feature;
	}

	/**
	 * todo:
	 *
	 * @param feature
	 */
	protected void removeFeature(@ActivityFeature int feature) {
		this.mFeatures &= ~feature;
	}

	/**
	 */
	@Override
	public void onContentChanged() {
		super.onContentChanged();
		if (hasFeature(FEATURE_DEPENDENCIES_INJECTION)) {
			ButterKnife.bind(this);
		}
		if (hasFeature(FEATURE_TOOLBAR)) {
			this.mToolbar = (Toolbar) findViewById(R.id.samples_toolbar);
			if (mToolbar == null) {
				throw new NullPointerException("No toolbar found within the view hierarchy!");
			}
			setSupportActionBar(mToolbar);
		}
	}

	/**
	 * todo:
	 *
	 * @return
	 */
	@NonNull
	public Toolbar getToolbar() {
		if (mToolbar == null) throw new NullPointerException(getClass().getSimpleName() + " has no toolbar available!");
		return mToolbar;
	}

	/**
	 */
	@Override
	public void setTitle(@Nullable CharSequence title) {
		if (mToolbar != null) mToolbar.setTitle(title);
		else super.setTitle(title);
	}

	/**
	 * Inner classes ===============================================================================
	 */
}
