/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.decoration;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.recycler.R;
import universum.studios.android.recycler.decoration.RecyclerViewItemDecoration;

public class ItemDividerDecoration
extends RecyclerViewItemDecoration {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation = 1;
    private Drawable drawable;
    private int thickness;
    private int offsetStart;
    private int offsetEnd;
    private Drawable offsetDrawable;
    private final Rect bounds = new Rect();

    public ItemDividerDecoration() {
        this(null);
    }

    public ItemDividerDecoration(int orientation, @NonNull Drawable drawable) {
        this(null);
        this.orientation = orientation;
        this.drawable = drawable;
        this.resolveDrawThickness();
    }

    public ItemDividerDecoration(@Nullable Context context) {
        this(context, null);
    }

    public ItemDividerDecoration(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ItemDividerDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ItemDividerDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setSkipLast(true);
        if (context != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Recycler_ItemDecoration_Divider, defStyleAttr, defStyleRes);
            int attributeCount = attributes.getIndexCount();
            for (int i = 0; i < attributeCount; ++i) {
                int attrIndex = attributes.getIndex(i);
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOrientation) {
                    this.setOrientation(attributes.getInt(attrIndex, this.orientation));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDivider) {
                    this.setDrawable(attributes.getDrawable(attrIndex));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerThickness) {
                    this.setThickness(attributes.getDimensionPixelSize(attrIndex, 0));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOffsetStart) {
                    this.setOffset(attributes.getDimensionPixelSize(attrIndex, 0), this.offsetEnd);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOffsetEnd) {
                    this.setOffset(this.offsetStart, attributes.getDimensionPixelSize(attrIndex, 0));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOffsetDrawable) {
                    this.setOffsetDrawable(attributes.getDrawable(attrIndex));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerSkipFirst) {
                    this.setSkipFirst(attributes.getBoolean(attrIndex, this.skipsFirst()));
                    continue;
                }
                if (attrIndex != R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerSkipLast) continue;
                this.setSkipLast(attributes.getBoolean(attrIndex, this.skipsLast()));
            }
            attributes.recycle();
        }
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.resolveDrawThickness();
    }

    public int getOrientation() {
        return this.orientation;
    }

    @Deprecated
    public void setDivider(@Nullable Drawable divider) {
        this.setDrawable(divider);
    }

    public void setDrawable(@Nullable Drawable drawable) {
        this.drawable = drawable;
        this.resolveDrawThickness();
    }

    @Deprecated
    @Nullable
    public Drawable getDivider() {
        return this.drawable;
    }

    @Nullable
    public Drawable getDrawable() {
        return this.drawable;
    }

    @Deprecated
    public void setDividerThickness(@IntRange(from=0L) int thickness) {
        this.setThickness(thickness);
    }

    public void setThickness(@IntRange(from=0L) int thickness) {
        this.thickness = thickness;
    }

    @Deprecated
    @IntRange(from=0L)
    public int getDividerThickness() {
        return this.getThickness();
    }

    @IntRange(from=0L)
    public int getThickness() {
        return this.thickness;
    }

    private void resolveDrawThickness() {
        if (this.drawable == null) {
            this.thickness = 0;
        } else {
            switch (this.orientation) {
                case 0: {
                    this.thickness = this.drawable.getIntrinsicWidth();
                    break;
                }
                default: {
                    this.thickness = this.drawable.getIntrinsicHeight();
                }
            }
        }
    }

    @Deprecated
    public void setDividerOffset(@IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        this.setOffset(start, end);
    }

    public void setOffset(@IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        this.offsetStart = start;
        this.offsetEnd = end;
    }

    @Deprecated
    public int getDividerOffsetStart() {
        return this.getOffsetStart();
    }

    public int getOffsetStart() {
        return this.offsetStart;
    }

    @Deprecated
    public int getDividerOffsetEnd() {
        return this.getOffsetEnd();
    }

    public int getOffsetEnd() {
        return this.offsetEnd;
    }

    public void setOffsetDrawable(@Nullable Drawable drawable) {
        this.offsetDrawable = drawable;
    }

    @Nullable
    public Drawable getOffsetDrawable() {
        return this.offsetDrawable;
    }

    @Override
    protected boolean shouldDecorate(@NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        return super.shouldDecorate(parent, state) && this.drawable != null && this.thickness > 0;
    }

    public void getItemOffsets(@NonNull Rect rect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        rect.setEmpty();
        if (this.shouldDecorate(parent, state)) {
            if (this.skipFirst || this.skipLast) {
                int position = parent.getChildAdapterPosition(view);
                if (position == -1) {
                    return;
                }
                if (this.skipFirst && position == 0 || this.skipLast && position == state.getItemCount() - 1) {
                    return;
                }
            }
            if (this.precondition.check(view, parent, state)) {
                this.updateItemOffsets(rect, ViewCompat.getLayoutDirection((View)parent) == 1);
            }
        }
    }

    protected void updateItemOffsets(@NonNull Rect rect, boolean rtlDirection) {
        switch (this.orientation) {
            case 0: {
                rect.set(0, 0, this.thickness, 0);
                break;
            }
            default: {
                rect.set(0, 0, 0, this.thickness);
            }
        }
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.shouldDecorate(parent, state)) {
            switch (this.orientation) {
                case 0: {
                    this.onDrawHorizontally(canvas, parent, state);
                    break;
                }
                default: {
                    this.onDrawVertically(canvas, parent, state);
                }
            }
        }
    }

    protected void onDrawHorizontally(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int bottom;
        int top;
        canvas.save();
        if (parent.getClipToPadding()) {
            top = parent.getPaddingTop();
            bottom = parent.getHeight() - parent.getPaddingBottom();
            canvas.clipRect(parent.getPaddingLeft(), top, parent.getWidth() - parent.getPaddingRight(), bottom);
        } else {
            top = 0;
            bottom = parent.getHeight();
        }
        int parentTop = top;
        int parentBottom = bottom;
        top += this.offsetStart;
        bottom -= this.offsetEnd;
        int itemCount = state.getItemCount();
        int childCount = parent.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            View child = parent.getChildAt(childIndex);
            if (this.skipFirst || this.skipLast) {
                int position = parent.getChildAdapterPosition(child);
                if (this.skipFirst && position == 0 || this.skipLast && position == itemCount - 1) continue;
            }
            if (!this.precondition.check(child, parent, state)) continue;
            parent.getDecoratedBoundsWithMargins(child, this.bounds);
            int right = this.bounds.right + Math.round(child.getTranslationX());
            int left = right - this.thickness;
            if (this.offsetDrawable != null) {
                if (this.offsetStart > 0) {
                    this.offsetDrawable.setBounds(left, parentTop, right, top);
                    this.offsetDrawable.draw(canvas);
                }
                if (this.offsetEnd > 0) {
                    this.offsetDrawable.setBounds(left, bottom, right, parentBottom);
                    this.offsetDrawable.draw(canvas);
                }
            }
            this.drawable.setBounds(left, top, right, bottom);
            this.drawable.draw(canvas);
        }
        canvas.restore();
    }

    protected void onDrawVertically(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int right;
        int left;
        canvas.save();
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
            canvas.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
        } else {
            left = 0;
            right = parent.getWidth();
        }
        boolean hasRtlDirection = ViewCompat.getLayoutDirection((View)parent) == 1;
        int parentLeft = left;
        int parentRight = right;
        left += hasRtlDirection ? this.offsetEnd : this.offsetStart;
        right -= hasRtlDirection ? this.offsetStart : this.offsetEnd;
        int itemCount = state.getItemCount();
        int childCount = parent.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            View child = parent.getChildAt(childIndex);
            if (this.skipFirst || this.skipLast) {
                int position = parent.getChildAdapterPosition(child);
                if (this.skipFirst && position == 0 || this.skipLast && position == itemCount - 1) continue;
            }
            if (!this.precondition.check(child, parent, state)) continue;
            parent.getDecoratedBoundsWithMargins(child, this.bounds);
            int bottom = this.bounds.bottom + Math.round(child.getTranslationY());
            int top = bottom - this.thickness;
            if (this.offsetDrawable != null) {
                if (this.offsetStart > 0) {
                    this.offsetDrawable.setBounds(parentLeft, top, left, bottom);
                    this.offsetDrawable.draw(canvas);
                }
                if (this.offsetEnd > 0) {
                    this.offsetDrawable.setBounds(right, top, parentRight, bottom);
                    this.offsetDrawable.draw(canvas);
                }
            }
            this.drawable.setBounds(left, top, right, bottom);
            this.drawable.draw(canvas);
        }
        canvas.restore();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

