/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.decoration;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.recyclerview.widget.RecyclerView;
import universum.studios.android.recycler.R;

public abstract class RecyclerViewItemDecoration
extends RecyclerView.ItemDecoration {
    boolean skipFirst;
    boolean skipLast;
    @NonNull
    Precondition precondition = Precondition.EMPTY;

    public RecyclerViewItemDecoration() {
        this(null);
    }

    public RecyclerViewItemDecoration(@Nullable Context context) {
        this(context, null);
    }

    public RecyclerViewItemDecoration(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerViewItemDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RecyclerViewItemDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        if (context != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Recycler_ItemDecoration, defStyleAttr, defStyleRes);
            int attributeCount = attributes.getIndexCount();
            for (int i = 0; i < attributeCount; ++i) {
                int attrIndex = attributes.getIndex(i);
                if (attrIndex == R.styleable.Recycler_ItemDecoration_recyclerItemDecorationSkipFirst) {
                    this.skipFirst = attributes.getBoolean(attrIndex, false);
                    continue;
                }
                if (attrIndex != R.styleable.Recycler_ItemDecoration_recyclerItemDecorationSkipLast) continue;
                this.skipLast = attributes.getBoolean(attrIndex, false);
            }
            attributes.recycle();
        }
    }

    public void setSkipFirst(boolean skip) {
        this.skipFirst = skip;
    }

    public boolean skipsFirst() {
        return this.skipFirst;
    }

    public void setSkipLast(boolean skip) {
        this.skipLast = skip;
    }

    public boolean skipsLast() {
        return this.skipLast;
    }

    public final void setPrecondition(@NonNull Precondition precondition) {
        this.precondition = precondition;
    }

    @NonNull
    public final Precondition getPrecondition() {
        return this.precondition;
    }

    protected boolean shouldDecorate(@NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        return parent.getLayoutManager() != null && state.getItemCount() > 0;
    }

    public static interface Precondition {
        @NonNull
        public static final Precondition EMPTY = new Precondition(){

            @Override
            public boolean check(@NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                return true;
            }
        };

        public boolean check(@NonNull View var1, @NonNull RecyclerView var2, @NonNull RecyclerView.State var3);
    }
}

