/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.decoration;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import universum.studios.android.recycler.R;
import universum.studios.android.recycler.decoration.RecyclerViewItemDecoration;

public class ItemSpaceDecoration
extends RecyclerViewItemDecoration {
    private int horizontalStart;
    private int horizontalEnd;
    private int verticalStart;
    private int verticalEnd;

    public ItemSpaceDecoration() {
        this(null);
    }

    public ItemSpaceDecoration(int horizontal, int vertical) {
        this(horizontal, horizontal, vertical, vertical);
    }

    public ItemSpaceDecoration(int horizontalStart, int horizontalEnd, int verticalStart, int verticalEnd) {
        this.horizontalStart = horizontalStart;
        this.horizontalEnd = horizontalEnd;
        this.verticalStart = verticalStart;
        this.verticalEnd = verticalEnd;
    }

    public ItemSpaceDecoration(@Nullable Context context) {
        this(context, null);
    }

    public ItemSpaceDecoration(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ItemSpaceDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ItemSpaceDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (context != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Recycler_ItemDecoration_Space, defStyleAttr, defStyleRes);
            int attributeCount = attributes.getIndexCount();
            for (int i = 0; i < attributeCount; ++i) {
                int attrIndex = attributes.getIndex(i);
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingHorizontalStart) {
                    this.horizontalStart = attributes.getDimensionPixelSize(attrIndex, 0);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingHorizontalEnd) {
                    this.horizontalEnd = attributes.getDimensionPixelSize(attrIndex, 0);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingVerticalStart) {
                    this.verticalStart = attributes.getDimensionPixelSize(attrIndex, 0);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingVerticalEnd) {
                    this.verticalEnd = attributes.getDimensionPixelSize(attrIndex, 0);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingSkipFirst) {
                    this.setSkipFirst(attributes.getBoolean(attrIndex, this.skipsFirst()));
                    continue;
                }
                if (attrIndex != R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingSkipLast) continue;
                this.setSkipLast(attributes.getBoolean(attrIndex, this.skipsLast()));
            }
            attributes.recycle();
        }
    }

    public int getHorizontalStart() {
        return this.horizontalStart;
    }

    public int getHorizontalEnd() {
        return this.horizontalEnd;
    }

    public int getVerticalStart() {
        return this.verticalStart;
    }

    public int getVerticalEnd() {
        return this.verticalEnd;
    }

    public void getItemOffsets(@NonNull Rect rect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.skipFirst || this.skipLast) {
            int position = parent.getChildAdapterPosition(view);
            if (position == -1) {
                rect.setEmpty();
                return;
            }
            if (this.skipFirst && position == 0 || this.skipLast && position == state.getItemCount() - 1) {
                rect.setEmpty();
                return;
            }
        }
        if (this.precondition.check(view, parent, state)) {
            this.updateItemOffsets(rect, ViewCompat.getLayoutDirection((View)parent) == 1);
        } else {
            rect.setEmpty();
        }
    }

    protected void updateItemOffsets(@NonNull Rect rect, boolean rtlDirection) {
        rect.set(rtlDirection ? this.horizontalEnd : this.horizontalStart, this.verticalStart, rtlDirection ? this.horizontalStart : this.horizontalEnd, this.verticalEnd);
    }
}

