/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.decoration;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.AttrRes;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.recycler.R;
import universum.studios.android.recycler.decoration.RecyclerViewItemDecoration;

public class ItemDividerDecoration
extends RecyclerViewItemDecoration {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation = 1;
    private Drawable divider;
    private int dividerThickness;
    private int dividerOffsetStart;
    private int dividerOffsetEnd;
    private final Rect bounds = new Rect();

    public ItemDividerDecoration() {
        this(null);
    }

    public ItemDividerDecoration(int orientation, @NonNull Drawable divider) {
        this(null);
        this.orientation = orientation;
        this.divider = divider;
        this.resolveDividerDrawThickness();
    }

    public ItemDividerDecoration(@Nullable Context context) {
        this(context, null);
    }

    public ItemDividerDecoration(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ItemDividerDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ItemDividerDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setSkipLast(true);
        if (context != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Recycler_ItemDecoration_Divider, defStyleAttr, defStyleRes);
            int attributeCount = attributes.getIndexCount();
            for (int i = 0; i < attributeCount; ++i) {
                int attrIndex = attributes.getIndex(i);
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOrientation) {
                    this.setOrientation(attributes.getInt(attrIndex, this.orientation));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDivider) {
                    this.setDivider(attributes.getDrawable(attrIndex));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerThickness) {
                    this.setDividerThickness(attributes.getDimensionPixelSize(attrIndex, 0));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOffsetStart) {
                    this.setDividerOffset(attributes.getDimensionPixelSize(attrIndex, 0), this.dividerOffsetEnd);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOffsetEnd) {
                    this.setDividerOffset(this.dividerOffsetStart, attributes.getDimensionPixelSize(attrIndex, 0));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerSkipFirst) {
                    this.setSkipFirst(attributes.getBoolean(attrIndex, this.skipsFirst()));
                    continue;
                }
                if (attrIndex != R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerSkipLast) continue;
                this.setSkipLast(attributes.getBoolean(attrIndex, this.skipsLast()));
            }
            attributes.recycle();
        }
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.resolveDividerDrawThickness();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setDivider(@Nullable Drawable divider) {
        this.divider = divider;
        this.resolveDividerDrawThickness();
    }

    @Nullable
    public Drawable getDivider() {
        return this.divider;
    }

    public void setDividerThickness(@IntRange(from=0L) int thickness) {
        this.dividerThickness = thickness;
    }

    @IntRange(from=0L)
    public int getDividerThickness() {
        return this.dividerThickness;
    }

    private void resolveDividerDrawThickness() {
        if (this.divider == null) {
            this.dividerThickness = 0;
        } else {
            switch (this.orientation) {
                case 0: {
                    this.dividerThickness = this.divider.getIntrinsicWidth();
                    break;
                }
                default: {
                    this.dividerThickness = this.divider.getIntrinsicHeight();
                }
            }
        }
    }

    public void setDividerOffset(@IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        this.dividerOffsetStart = start;
        this.dividerOffsetEnd = end;
    }

    public int getDividerOffsetStart() {
        return this.dividerOffsetStart;
    }

    public int getDividerOffsetEnd() {
        return this.dividerOffsetEnd;
    }

    public void getItemOffsets(@NonNull Rect rect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.dividerThickness > 0) {
            if (this.skipFirst || this.skipLast) {
                int position = parent.getChildAdapterPosition(view);
                if (position == -1) {
                    rect.setEmpty();
                    return;
                }
                if (this.skipFirst && position == 0 || this.skipLast && position == state.getItemCount() - 1) {
                    rect.setEmpty();
                    return;
                }
            }
            if (this.precondition.check(view, parent, state)) {
                this.updateItemOffsets(rect, ViewCompat.getLayoutDirection((View)parent) == 1);
            } else {
                rect.setEmpty();
            }
        }
    }

    protected void updateItemOffsets(@NonNull Rect rect, boolean rtlDirection) {
        switch (this.orientation) {
            case 0: {
                rect.set(0, 0, this.dividerThickness, 0);
                break;
            }
            default: {
                rect.set(0, 0, 0, this.dividerThickness);
            }
        }
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.shouldDecorate(parent, state)) {
            switch (this.orientation) {
                case 0: {
                    this.onDrawHorizontally(canvas, parent, state);
                    break;
                }
                default: {
                    this.onDrawVertically(canvas, parent, state);
                }
            }
        }
    }

    @Override
    protected boolean shouldDecorate(@NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        return super.shouldDecorate(parent, state) && this.divider != null && this.dividerThickness > 0;
    }

    protected void onDrawHorizontally(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int bottom;
        int top;
        canvas.save();
        if (parent.getClipToPadding()) {
            top = parent.getPaddingTop();
            bottom = parent.getHeight() - parent.getPaddingBottom();
            canvas.clipRect(parent.getPaddingLeft(), top, parent.getWidth() - parent.getPaddingRight(), bottom);
        } else {
            top = 0;
            bottom = parent.getHeight();
        }
        top += this.dividerOffsetStart;
        bottom -= this.dividerOffsetEnd;
        int itemCount = state.getItemCount();
        int childCount = parent.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            View child = parent.getChildAt(childIndex);
            if (this.skipFirst || this.skipLast) {
                int position = parent.getChildAdapterPosition(child);
                if (this.skipFirst && position == 0 || this.skipLast && position == itemCount - 1) continue;
            }
            if (!this.precondition.check(child, parent, state)) continue;
            parent.getDecoratedBoundsWithMargins(child, this.bounds);
            int right = this.bounds.right + Math.round(child.getTranslationX());
            int left = right - this.dividerThickness;
            this.divider.setBounds(left, top, right, bottom);
            this.divider.draw(canvas);
        }
        canvas.restore();
    }

    protected void onDrawVertically(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int right;
        int left;
        canvas.save();
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
            canvas.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
        } else {
            left = 0;
            right = parent.getWidth();
        }
        boolean hasRtlDirection = ViewCompat.getLayoutDirection((View)parent) == 1;
        left += hasRtlDirection ? this.dividerOffsetEnd : this.dividerOffsetStart;
        right -= hasRtlDirection ? this.dividerOffsetStart : this.dividerOffsetEnd;
        int itemCount = state.getItemCount();
        int childCount = parent.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            View child = parent.getChildAt(childIndex);
            if (this.skipFirst || this.skipLast) {
                int position = parent.getChildAdapterPosition(child);
                if (this.skipFirst && position == 0 || this.skipLast && position == itemCount - 1) continue;
            }
            if (!this.precondition.check(child, parent, state)) continue;
            parent.getDecoratedBoundsWithMargins(child, this.bounds);
            int bottom = this.bounds.bottom + Math.round(child.getTranslationY());
            int top = bottom - this.dividerThickness;
            this.divider.setBounds(left, top, right, bottom);
            this.divider.draw(canvas);
        }
        canvas.restore();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

