/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.helper;

import android.animation.TimeInterpolator;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewPropertyAnimator;
import android.view.animation.Interpolator;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.recycler.helper.RecyclerViewItemHelper;

public final class ItemSwipeHelper
extends RecyclerViewItemHelper<Interactor> {
    public static final int INTERACTION = 1;
    public static final float SWIPE_THRESHOLD = 0.5f;
    public static final long RESTORE_HOLDER_ANIMATION_DURATION = 300L;
    private long restoreHolderAnimationDuration = 300L;
    private Interpolator restoreHolderAnimationInterpolator = new FastOutSlowInInterpolator();

    public ItemSwipeHelper() {
        this(new Interactor());
    }

    private ItemSwipeHelper(Interactor interactor) {
        super(interactor);
    }

    public static int makeSwipeFlags(int movementFlags) {
        return Interactor.makeMovementFlags((int)0, (int)movementFlags);
    }

    public void setRestoreHolderAnimationDuration(@IntRange(from=0L) long duration) {
        this.restoreHolderAnimationDuration = Math.max(0L, duration);
    }

    public long getRestoreHolderAnimationDuration() {
        return this.restoreHolderAnimationDuration;
    }

    public void setRestoreHolderAnimationInterpolator(@NonNull Interpolator interpolator) {
        this.restoreHolderAnimationInterpolator = interpolator;
    }

    @NonNull
    public Interpolator getRestoreHolderAnimationInterpolator() {
        return this.restoreHolderAnimationInterpolator;
    }

    public boolean restoreHolder(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
        return this.restoreHolder(viewHolder, direction, null);
    }

    public boolean restoreHolder(@NonNull RecyclerView.ViewHolder viewHolder, int direction, final @Nullable Runnable animationCallback) {
        final int holderPosition = viewHolder.getAdapterPosition();
        if (viewHolder instanceof SwipeViewHolder && holderPosition != -1) {
            View swipeView = ((SwipeViewHolder)viewHolder).getInteractiveView(1);
            if (swipeView == null) {
                return false;
            }
            ViewPropertyAnimator animator = null;
            switch (direction) {
                case 4: 
                case 8: 
                case 16: 
                case 32: {
                    if (swipeView.getTranslationX() == 0.0f) break;
                    animator = swipeView.animate().translationX(0.0f);
                    break;
                }
                case 1: 
                case 2: {
                    if (swipeView.getTranslationY() == 0.0f) break;
                    animator = swipeView.animate().translationY(0.0f);
                    break;
                }
                default: {
                    return false;
                }
            }
            Runnable notify = new Runnable(){

                @Override
                public void run() {
                    if (((Interactor)ItemSwipeHelper.this.interactor).adapter != null) {
                        ((Interactor)ItemSwipeHelper.this.interactor).adapter.notifyItemChanged(holderPosition);
                    }
                    if (animationCallback != null) {
                        animationCallback.run();
                    }
                }
            };
            if (animator == null) {
                notify.run();
            } else {
                animator.setDuration(this.restoreHolderAnimationDuration).setInterpolator((TimeInterpolator)this.restoreHolderAnimationInterpolator).start();
                swipeView.postDelayed(notify, this.restoreHolderAnimationDuration);
            }
            return true;
        }
        return false;
    }

    public static class SwipeItemAnimator
    extends DefaultItemAnimator {
        public boolean animateChange(@NonNull RecyclerView.ViewHolder oldHolder, @NonNull RecyclerView.ViewHolder newHolder, int fromX, int fromY, int toX, int toY) {
            if (fromX == toX && fromY == toY) {
                if (newHolder.equals(oldHolder)) {
                    this.dispatchChangeFinished(newHolder, false);
                } else {
                    this.dispatchChangeFinished(oldHolder, true);
                    this.dispatchChangeFinished(newHolder, false);
                }
                return false;
            }
            return super.animateChange(oldHolder, newHolder, fromX, fromY, toX, toY);
        }
    }

    public static final class Interactor
    extends RecyclerViewItemHelper.ItemInteractor {
        private float swipeThreshold = 0.5f;
        private boolean itemSwipeEnabled = true;
        @VisibleForTesting
        SwipeAdapter swipeAdapter;
        private List<OnSwipeListener> listeners;
        @VisibleForTesting
        boolean swiping;

        Interactor() {
        }

        public void setItemViewSwipeEnabled(boolean enabled) {
            this.itemSwipeEnabled = enabled;
        }

        public boolean isItemViewSwipeEnabled() {
            return this.itemSwipeEnabled;
        }

        public void setSwipeThreshold(@FloatRange(from=0.0, to=1.0) float threshold) {
            this.swipeThreshold = Math.min(Math.max(threshold, 0.0f), 1.0f);
        }

        @FloatRange(from=0.0, to=1.0)
        public float getSwipeThreshold() {
            return this.swipeThreshold;
        }

        public float getSwipeThreshold(@NonNull RecyclerView.ViewHolder viewHolder) {
            return this.swipeThreshold;
        }

        public void addOnSwipeListener(@NonNull OnSwipeListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<OnSwipeListener>(1);
            }
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        public void removeOnSwipeListener(@NonNull OnSwipeListener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }

        @VisibleForTesting
        void notifySwipeStarted(RecyclerView.ViewHolder viewHolder) {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                for (OnSwipeListener listener : this.listeners) {
                    listener.onSwipeStarted((ItemSwipeHelper)this.helper, viewHolder);
                }
            }
        }

        @VisibleForTesting
        void notifySwipeFinished(RecyclerView.ViewHolder viewHolder, int direction) {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                for (OnSwipeListener listener : this.listeners) {
                    listener.onSwipeFinished((ItemSwipeHelper)this.helper, viewHolder, direction);
                }
            }
        }

        @VisibleForTesting
        void notifySwipeCanceled(RecyclerView.ViewHolder viewHolder) {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                for (OnSwipeListener listener : this.listeners) {
                    listener.onSwipeCanceled((ItemSwipeHelper)this.helper, viewHolder);
                }
            }
        }

        @Override
        protected boolean canAttachAdapter(@NonNull RecyclerView.Adapter adapter) {
            return adapter instanceof SwipeAdapter;
        }

        @Override
        protected void onAdapterAttached(@NonNull RecyclerView.Adapter adapter) {
            super.onAdapterAttached(adapter);
            this.swipeAdapter = (SwipeAdapter)adapter;
        }

        @Override
        protected void onAdapterDetached(@NonNull RecyclerView.Adapter adapter) {
            super.onAdapterDetached(adapter);
            this.swipeAdapter = null;
            this.resetState();
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.resetState();
        }

        private void resetState() {
            this.swiping = false;
        }

        @Override
        public boolean isActive() {
            return this.swiping;
        }

        public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
            return this.shouldHandleInteraction() && viewHolder instanceof SwipeViewHolder ? this.swipeAdapter.getItemSwipeFlags(viewHolder.getAdapterPosition()) : 0;
        }

        public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int actionState) {
            if (this.shouldHandleInteraction() && viewHolder instanceof SwipeViewHolder) {
                switch (actionState) {
                    case 1: {
                        this.swiping = true;
                        SwipeViewHolder swipeViewHolder = (SwipeViewHolder)viewHolder;
                        View interactiveView = swipeViewHolder.getInteractiveView(1);
                        if (interactiveView == null) {
                            super.onSelectedChanged(viewHolder, actionState);
                        } else {
                            Interactor.getDefaultUIUtil().onSelected(interactiveView);
                        }
                        swipeViewHolder.onSwipeStarted();
                        this.notifySwipeStarted(viewHolder);
                        break;
                    }
                    default: {
                        super.onSelectedChanged(viewHolder, actionState);
                        break;
                    }
                }
            } else {
                super.onSelectedChanged(viewHolder, actionState);
            }
        }

        public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, @NonNull RecyclerView.ViewHolder target) {
            return false;
        }

        public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
            if (this.shouldHandleInteraction() && viewHolder instanceof SwipeViewHolder) {
                SwipeViewHolder swipeViewHolder = (SwipeViewHolder)viewHolder;
                swipeViewHolder.onSwipeFinished(direction);
                this.notifySwipeFinished(viewHolder, direction);
                this.resetState();
            }
        }

        public void clearView(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
            if (this.shouldHandleInteraction() && viewHolder instanceof SwipeViewHolder) {
                SwipeViewHolder swipeViewHolder = (SwipeViewHolder)viewHolder;
                View interactiveView = swipeViewHolder.getInteractiveView(1);
                if (interactiveView == null) {
                    super.clearView(recyclerView, viewHolder);
                } else {
                    Interactor.getDefaultUIUtil().clearView(interactiveView);
                }
                int adapterPosition = viewHolder.getAdapterPosition();
                if (adapterPosition != -1 && !recyclerView.isComputingLayout()) {
                    swipeViewHolder.onSwipeCanceled();
                    this.notifySwipeCanceled(viewHolder);
                }
                this.resetState();
            } else {
                super.clearView(recyclerView, viewHolder);
            }
        }
    }

    public static interface OnSwipeListener {
        public void onSwipeStarted(@NonNull ItemSwipeHelper var1, @NonNull RecyclerView.ViewHolder var2);

        public void onSwipeFinished(@NonNull ItemSwipeHelper var1, @NonNull RecyclerView.ViewHolder var2, int var3);

        public void onSwipeCanceled(@NonNull ItemSwipeHelper var1, @NonNull RecyclerView.ViewHolder var2);
    }

    public static interface SwipeViewHolder
    extends RecyclerViewItemHelper.InteractiveViewHolder {
        public void onSwipeStarted();

        public void onSwipeFinished(int var1);

        public void onSwipeCanceled();
    }

    public static interface SwipeAdapter {
        public int getItemSwipeFlags(int var1);
    }
}

