/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.helper;

import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v7.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import universum.studios.android.recycler.helper.RecyclerViewItemHelper;

public final class ItemDragHelper
extends RecyclerViewItemHelper<Interactor> {
    public static final int INTERACTION = 2;
    public static final float MOVE_THRESHOLD = 0.5f;

    public ItemDragHelper() {
        this(new Interactor());
    }

    private ItemDragHelper(@NonNull Interactor interactor) {
        super(interactor);
    }

    public static int makeDragFlags(int movementFlags) {
        return Interactor.makeMovementFlags((int)movementFlags, (int)0);
    }

    public static final class Interactor
    extends RecyclerViewItemHelper.ItemInteractor {
        private float dragThreshold = 0.5f;
        private boolean longPressDragEnabled = true;
        @VisibleForTesting
        DragAdapter dragAdapter;
        private List<OnDragListener> listeners;
        @VisibleForTesting
        boolean dragging;
        @VisibleForTesting
        int draggingFromPosition = -1;
        @VisibleForTesting
        int movingFromPosition = -1;
        @VisibleForTesting
        int movingToPosition = -1;

        Interactor() {
        }

        public void setLongPressDragEnabled(boolean enabled) {
            this.longPressDragEnabled = enabled;
        }

        public boolean isLongPressDragEnabled() {
            return this.longPressDragEnabled;
        }

        public void setDragThreshold(@FloatRange(from=0.0, to=1.0) float threshold) {
            this.dragThreshold = Math.min(Math.max(threshold, 0.0f), 1.0f);
        }

        @FloatRange(from=0.0, to=1.0)
        public float getDragThreshold() {
            return this.dragThreshold;
        }

        public float getMoveThreshold(@NonNull RecyclerView.ViewHolder viewHolder) {
            return this.dragThreshold;
        }

        public void addOnDragListener(@NonNull OnDragListener listener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<OnDragListener>(1);
            }
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }

        @VisibleForTesting
        void notifyDragStarted(RecyclerView.ViewHolder viewHolder) {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                for (OnDragListener listener : this.listeners) {
                    listener.onDragStarted((ItemDragHelper)this.helper, viewHolder);
                }
            }
        }

        @VisibleForTesting
        void notifyDragFinished(RecyclerView.ViewHolder viewHolder, int fromPosition, int toPosition) {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                for (OnDragListener listener : this.listeners) {
                    listener.onDragFinished((ItemDragHelper)this.helper, viewHolder, fromPosition, toPosition);
                }
            }
        }

        @VisibleForTesting
        void notifyDragCanceled(RecyclerView.ViewHolder viewHolder) {
            if (this.listeners != null && !this.listeners.isEmpty()) {
                for (OnDragListener listener : this.listeners) {
                    listener.onDragCanceled((ItemDragHelper)this.helper, viewHolder);
                }
            }
        }

        public void removeOnDragListener(@NonNull OnDragListener listener) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }

        @Override
        protected boolean canAttachAdapter(@NonNull RecyclerView.Adapter adapter) {
            return adapter instanceof DragAdapter;
        }

        @Override
        protected void onAdapterAttached(@NonNull RecyclerView.Adapter adapter) {
            super.onAdapterAttached(adapter);
            this.dragAdapter = (DragAdapter)adapter;
        }

        @Override
        protected void onAdapterDetached(@NonNull RecyclerView.Adapter adapter) {
            super.onAdapterDetached(adapter);
            this.dragAdapter = null;
            this.resetState();
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.resetState();
        }

        @VisibleForTesting
        void resetState() {
            this.dragging = false;
            this.movingToPosition = -1;
            this.movingFromPosition = -1;
            this.draggingFromPosition = -1;
        }

        @Override
        public boolean isActive() {
            return this.dragging;
        }

        public int getMovementFlags(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
            return this.shouldHandleInteraction() && viewHolder instanceof DragViewHolder ? this.dragAdapter.getItemDragFlags(viewHolder.getAdapterPosition()) : 0;
        }

        public void onSelectedChanged(@Nullable RecyclerView.ViewHolder viewHolder, int actionState) {
            super.onSelectedChanged(viewHolder, actionState);
            if (this.shouldHandleInteraction() && viewHolder instanceof DragViewHolder) {
                switch (actionState) {
                    case 2: {
                        this.dragging = true;
                        ((DragViewHolder)viewHolder).onDragStarted();
                        this.draggingFromPosition = viewHolder.getAdapterPosition();
                        this.dragAdapter.onItemDragStarted(this.draggingFromPosition);
                        this.notifyDragStarted(viewHolder);
                        break;
                    }
                }
            }
        }

        public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder current, @NonNull RecyclerView.ViewHolder target) {
            int toPosition;
            int fromPosition;
            if (this.shouldHandleInteraction() && current instanceof DragViewHolder && target instanceof DragViewHolder && (fromPosition = current.getAdapterPosition()) != (toPosition = target.getAdapterPosition()) && (fromPosition != this.movingFromPosition || toPosition != this.movingToPosition)) {
                this.movingFromPosition = fromPosition;
                this.movingToPosition = toPosition;
                return this.dragAdapter.onMoveItem(this.movingFromPosition, this.movingToPosition);
            }
            return false;
        }

        public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder, int direction) {
        }

        public boolean canDropOver(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder current, @NonNull RecyclerView.ViewHolder target) {
            return this.shouldHandleInteraction() && current instanceof DragViewHolder && target instanceof DragViewHolder && this.dragAdapter.canDropItemOver(current.getAdapterPosition(), target.getAdapterPosition());
        }

        public void clearView(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder) {
            super.clearView(recyclerView, viewHolder);
            if (this.shouldHandleInteraction() && viewHolder instanceof DragViewHolder) {
                int draggingToPosition = viewHolder.getAdapterPosition();
                ((DragViewHolder)viewHolder).onDragFinished(this.draggingFromPosition, draggingToPosition);
                this.dragAdapter.onItemDragFinished(this.draggingFromPosition, draggingToPosition);
                this.notifyDragFinished(viewHolder, this.draggingFromPosition, draggingToPosition);
                this.resetState();
            }
        }
    }

    public static interface OnDragListener {
        public void onDragStarted(@NonNull ItemDragHelper var1, @NonNull RecyclerView.ViewHolder var2);

        public void onDragFinished(@NonNull ItemDragHelper var1, @NonNull RecyclerView.ViewHolder var2, int var3, int var4);

        public void onDragCanceled(@NonNull ItemDragHelper var1, @NonNull RecyclerView.ViewHolder var2);
    }

    public static interface DragViewHolder
    extends RecyclerViewItemHelper.InteractiveViewHolder {
        public void onDragStarted();

        public void onDragFinished(int var1, int var2);

        public void onDragCanceled();
    }

    public static interface DragAdapter {
        public int getItemDragFlags(int var1);

        public void onItemDragStarted(int var1);

        public boolean onMoveItem(int var1, int var2);

        public boolean canDropItemOver(int var1, int var2);

        public void onItemDragFinished(int var1, int var2);
    }
}

