/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.helper;

import android.graphics.Canvas;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public abstract class RecyclerViewItemHelper<I extends ItemInteractor>
extends ItemTouchHelper {
    final I mInteractor;

    protected RecyclerViewItemHelper(@NonNull I interactor) {
        super(interactor);
        this.mInteractor = interactor;
        ((ItemInteractor)((Object)this.mInteractor)).attachToHelper(this);
    }

    @NonNull
    public final I getInteractor() {
        return this.mInteractor;
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) {
        super.attachToRecyclerView(recyclerView);
        if (recyclerView == null) {
            ((ItemInteractor)((Object)this.mInteractor)).attachAdapter(null);
        } else {
            RecyclerView.Adapter adapter = recyclerView.getAdapter();
            if (adapter == null || ((ItemInteractor)((Object)this.mInteractor)).canAttachAdapter(adapter)) {
                ((ItemInteractor)((Object)this.mInteractor)).attachAdapter(adapter);
            } else {
                throw new IllegalArgumentException("Cannot attach adapter(" + adapter + ") to this(" + (Object)((Object)this) + ") item helper.");
            }
        }
    }

    public static abstract class ItemInteractor
    extends ItemTouchHelper.Callback {
        boolean enabled = true;
        RecyclerViewItemHelper helper;
        RecyclerView.Adapter adapter;

        final void attachToHelper(RecyclerViewItemHelper helper) {
            this.helper = helper;
            this.onAttachedToHelper(this.helper);
        }

        protected void onAttachedToHelper(@NonNull RecyclerViewItemHelper helper) {
        }

        protected abstract boolean canAttachAdapter(@NonNull RecyclerView.Adapter var1);

        final void attachAdapter(RecyclerView.Adapter adapter) {
            if (this.adapter == adapter) {
                return;
            }
            if (this.adapter != null) {
                this.onAdapterDetached(this.adapter);
            }
            this.adapter = adapter;
            if (adapter != null) {
                this.onAdapterAttached(adapter);
            }
        }

        protected void onAdapterAttached(@NonNull RecyclerView.Adapter adapter) {
        }

        protected void onAdapterDetached(@NonNull RecyclerView.Adapter adapter) {
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public abstract boolean isActive();

        protected boolean shouldHandleInteraction() {
            return this.enabled && this.adapter != null;
        }

        public void onChildDraw(@NonNull Canvas canvas, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            if (viewHolder instanceof InteractiveViewHolder) {
                InteractiveViewHolder interactiveViewHolder = (InteractiveViewHolder)viewHolder;
                View interactiveView = interactiveViewHolder.getInteractiveView(actionState);
                if (interactiveView == null) {
                    super.onChildDraw(canvas, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
                } else {
                    ItemInteractor.getDefaultUIUtil().onDraw(canvas, recyclerView, interactiveView, dX, dY, actionState, isCurrentlyActive);
                }
                interactiveViewHolder.onDraw(canvas, dX, dY, actionState, isCurrentlyActive);
            } else {
                super.onChildDraw(canvas, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
            }
        }

        public void onChildDrawOver(@NonNull Canvas canvas, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            if (viewHolder instanceof InteractiveViewHolder) {
                InteractiveViewHolder interactiveViewHolder = (InteractiveViewHolder)viewHolder;
                View interactiveView = interactiveViewHolder.getInteractiveView(actionState);
                if (interactiveView == null) {
                    super.onChildDrawOver(canvas, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
                } else {
                    ItemInteractor.getDefaultUIUtil().onDrawOver(canvas, recyclerView, interactiveView, dX, dY, actionState, isCurrentlyActive);
                }
                interactiveViewHolder.onDrawOver(canvas, dX, dY, actionState, isCurrentlyActive);
            } else {
                super.onChildDrawOver(canvas, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
            }
        }
    }

    public static interface InteractiveViewHolder {
        @Nullable
        public View getInteractiveView(int var1);

        public void onDraw(@NonNull Canvas var1, float var2, float var3, int var4, boolean var5);

        public void onDrawOver(@NonNull Canvas var1, float var2, float var3, int var4, boolean var5);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Interaction {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Movement {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Direction {
    }
}

