/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.decoration;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import universum.studios.android.recycler.R;

public abstract class RecyclerViewItemDecoration
extends RecyclerView.ItemDecoration {
    boolean mSkipFirst;
    boolean mSkipLast;
    @NonNull
    Precondition mPrecondition = Precondition.EMPTY;

    public RecyclerViewItemDecoration() {
        this(null);
    }

    public RecyclerViewItemDecoration(@Nullable Context context) {
        this(context, null);
    }

    public RecyclerViewItemDecoration(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerViewItemDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public RecyclerViewItemDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        if (context != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Recycler_ItemDecoration, defStyleAttr, defStyleRes);
            int attributeCount = attributes.getIndexCount();
            for (int i = 0; i < attributeCount; ++i) {
                int attrIndex = attributes.getIndex(i);
                if (attrIndex == R.styleable.Recycler_ItemDecoration_recyclerItemDecorationSkipFirst) {
                    this.mSkipFirst = attributes.getBoolean(attrIndex, false);
                    continue;
                }
                if (attrIndex != R.styleable.Recycler_ItemDecoration_recyclerItemDecorationSkipLast) continue;
                this.mSkipLast = attributes.getBoolean(attrIndex, false);
            }
            attributes.recycle();
        }
    }

    public void setSkipFirst(boolean skip) {
        this.mSkipFirst = skip;
    }

    public boolean skipsFirst() {
        return this.mSkipFirst;
    }

    public void setSkipLast(boolean skip) {
        this.mSkipLast = skip;
    }

    public boolean skipsLast() {
        return this.mSkipLast;
    }

    public final void setPrecondition(@NonNull Precondition precondition) {
        this.mPrecondition = precondition;
    }

    @NonNull
    public final Precondition getPrecondition() {
        return this.mPrecondition;
    }

    protected boolean shouldDecorate(@NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        return parent.getLayoutManager() != null && state.getItemCount() > 0;
    }

    public static interface Precondition {
        @NonNull
        public static final Precondition EMPTY = new Precondition(){

            @Override
            public boolean check(@NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
                return true;
            }
        };

        public boolean check(@NonNull View var1, @NonNull RecyclerView var2, @NonNull RecyclerView.State var3);
    }
}

