/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.decoration;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.annotation.AttrRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import universum.studios.android.recycler.R;
import universum.studios.android.recycler.decoration.RecyclerViewItemDecoration;

public class ItemSpaceDecoration
extends RecyclerViewItemDecoration {
    private int mHorizontalStart;
    private int mHorizontalEnd;
    private int mVerticalStart;
    private int mVerticalEnd;

    public ItemSpaceDecoration() {
        this(null);
    }

    public ItemSpaceDecoration(int horizontal, int vertical) {
        this(horizontal, horizontal, vertical, vertical);
    }

    public ItemSpaceDecoration(int horizontalStart, int horizontalEnd, int verticalStart, int verticalEnd) {
        this.mHorizontalStart = horizontalStart;
        this.mHorizontalEnd = horizontalEnd;
        this.mVerticalStart = verticalStart;
        this.mVerticalEnd = verticalEnd;
    }

    public ItemSpaceDecoration(@Nullable Context context) {
        this(context, null);
    }

    public ItemSpaceDecoration(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ItemSpaceDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ItemSpaceDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (context != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Recycler_ItemDecoration_Space, defStyleAttr, defStyleRes);
            int attributeCount = attributes.getIndexCount();
            for (int i = 0; i < attributeCount; ++i) {
                int attrIndex = attributes.getIndex(i);
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingHorizontalStart) {
                    this.mHorizontalStart = attributes.getDimensionPixelSize(attrIndex, 0);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingHorizontalEnd) {
                    this.mHorizontalEnd = attributes.getDimensionPixelSize(attrIndex, 0);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingVerticalStart) {
                    this.mVerticalStart = attributes.getDimensionPixelSize(attrIndex, 0);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingVerticalEnd) {
                    this.mVerticalEnd = attributes.getDimensionPixelSize(attrIndex, 0);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingSkipFirst) {
                    this.setSkipFirst(attributes.getBoolean(attrIndex, this.skipsFirst()));
                    continue;
                }
                if (attrIndex != R.styleable.Recycler_ItemDecoration_Space_recyclerItemSpacingSkipLast) continue;
                this.setSkipLast(attributes.getBoolean(attrIndex, this.skipsLast()));
            }
            attributes.recycle();
        }
    }

    public int getHorizontalStart() {
        return this.mHorizontalStart;
    }

    public int getHorizontalEnd() {
        return this.mHorizontalEnd;
    }

    public int getVerticalStart() {
        return this.mVerticalStart;
    }

    public int getVerticalEnd() {
        return this.mVerticalEnd;
    }

    public void getItemOffsets(@NonNull Rect rect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.mSkipFirst || this.mSkipLast) {
            int position = parent.getChildAdapterPosition(view);
            if (position == -1) {
                rect.setEmpty();
                return;
            }
            if (this.mSkipFirst && position == 0 || this.mSkipLast && position == state.getItemCount() - 1) {
                rect.setEmpty();
                return;
            }
        }
        if (this.mPrecondition.check(view, parent, state)) {
            this.updateItemOffsets(rect, ViewCompat.getLayoutDirection((View)parent) == 1);
        } else {
            rect.setEmpty();
        }
    }

    protected void updateItemOffsets(@NonNull Rect rect, boolean rtlDirection) {
        rect.set(rtlDirection ? this.mHorizontalEnd : this.mHorizontalStart, this.mVerticalStart, rtlDirection ? this.mHorizontalStart : this.mHorizontalEnd, this.mVerticalEnd);
    }
}

