/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.recycler.decoration;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.recycler.R;
import universum.studios.android.recycler.decoration.RecyclerViewItemDecoration;

public class ItemDividerDecoration
extends RecyclerViewItemDecoration {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mOrientation = 1;
    private Drawable mDivider;
    private int mDividerThickness;
    private int mDividerOffsetStart;
    private int mDividerOffsetEnd;
    private final Rect mBounds = new Rect();

    public ItemDividerDecoration() {
        this(null);
    }

    public ItemDividerDecoration(int orientation, @NonNull Drawable divider) {
        this(null);
        this.mOrientation = orientation;
        this.mDivider = divider;
        this.resolveDividerDrawThickness();
    }

    public ItemDividerDecoration(@Nullable Context context) {
        this(context, null);
    }

    public ItemDividerDecoration(@Nullable Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ItemDividerDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ItemDividerDecoration(@Nullable Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setSkipLast(true);
        if (context != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.Recycler_ItemDecoration_Divider, defStyleAttr, defStyleRes);
            int attributeCount = attributes.getIndexCount();
            for (int i = 0; i < attributeCount; ++i) {
                int attrIndex = attributes.getIndex(i);
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOrientation) {
                    this.setOrientation(attributes.getInt(attrIndex, this.mOrientation));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDivider) {
                    this.setDivider(attributes.getDrawable(attrIndex));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerThickness) {
                    this.setDividerThickness(attributes.getDimensionPixelSize(attrIndex, 0));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOffsetStart) {
                    this.setDividerOffset(attributes.getDimensionPixelSize(attrIndex, 0), this.mDividerOffsetEnd);
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerOffsetEnd) {
                    this.setDividerOffset(this.mDividerOffsetStart, attributes.getDimensionPixelSize(attrIndex, 0));
                    continue;
                }
                if (attrIndex == R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerSkipFirst) {
                    this.setSkipFirst(attributes.getBoolean(attrIndex, this.skipsFirst()));
                    continue;
                }
                if (attrIndex != R.styleable.Recycler_ItemDecoration_Divider_recyclerDividerSkipLast) continue;
                this.setSkipLast(attributes.getBoolean(attrIndex, this.skipsLast()));
            }
            attributes.recycle();
        }
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
        this.resolveDividerDrawThickness();
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setDivider(@Nullable Drawable divider) {
        this.mDivider = divider;
        this.resolveDividerDrawThickness();
    }

    @Nullable
    public Drawable getDivider() {
        return this.mDivider;
    }

    public void setDividerThickness(@IntRange(from=0L) int thickness) {
        this.mDividerThickness = thickness;
    }

    @IntRange(from=0L)
    public int getDividerThickness() {
        return this.mDividerThickness;
    }

    private void resolveDividerDrawThickness() {
        if (this.mDivider == null) {
            this.mDividerThickness = 0;
        } else {
            switch (this.mOrientation) {
                case 0: {
                    this.mDividerThickness = this.mDivider.getIntrinsicWidth();
                    break;
                }
                default: {
                    this.mDividerThickness = this.mDivider.getIntrinsicHeight();
                }
            }
        }
    }

    public void setDividerOffset(@IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        this.mDividerOffsetStart = start;
        this.mDividerOffsetEnd = end;
    }

    public int getDividerOffsetStart() {
        return this.mDividerOffsetStart;
    }

    public int getDividerOffsetEnd() {
        return this.mDividerOffsetEnd;
    }

    public void getItemOffsets(@NonNull Rect rect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.mDividerThickness > 0) {
            if (this.mSkipFirst || this.mSkipLast) {
                int position = parent.getChildAdapterPosition(view);
                if (position == -1) {
                    rect.setEmpty();
                    return;
                }
                if (this.mSkipFirst && position == 0 || this.mSkipLast && position == state.getItemCount() - 1) {
                    rect.setEmpty();
                    return;
                }
            }
            if (this.mPrecondition.check(view, parent, state)) {
                this.updateItemOffsets(rect, ViewCompat.getLayoutDirection((View)parent) == 1);
            } else {
                rect.setEmpty();
            }
        }
    }

    protected void updateItemOffsets(@NonNull Rect rect, boolean rtlDirection) {
        switch (this.mOrientation) {
            case 0: {
                rect.set(0, this.mDividerOffsetStart, this.mDividerThickness, this.mDividerOffsetEnd);
                break;
            }
            default: {
                rect.set(rtlDirection ? this.mDividerOffsetEnd : this.mDividerOffsetStart, 0, rtlDirection ? this.mDividerOffsetStart : this.mDividerOffsetEnd, this.mDividerThickness);
            }
        }
    }

    public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.shouldDecorate(parent, state)) {
            switch (this.mOrientation) {
                case 0: {
                    this.onDrawHorizontally(canvas, parent, state);
                    break;
                }
                default: {
                    this.onDrawVertically(canvas, parent, state);
                }
            }
        }
    }

    @Override
    protected boolean shouldDecorate(@NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        return super.shouldDecorate(parent, state) && this.mDivider != null && this.mDividerThickness > 0;
    }

    protected void onDrawHorizontally(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int bottom;
        int top;
        canvas.save();
        if (parent.getClipToPadding()) {
            top = parent.getPaddingTop();
            bottom = parent.getHeight() - parent.getPaddingBottom();
            canvas.clipRect(parent.getPaddingLeft(), top, parent.getWidth() - parent.getPaddingRight(), bottom);
        } else {
            top = 0;
            bottom = parent.getHeight();
        }
        top += this.mDividerOffsetStart;
        bottom += this.mDividerOffsetEnd;
        int childCount = parent.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            View child;
            if (this.mSkipFirst && childIndex == 0 || this.mSkipLast && childIndex == childCount - 1 || !this.mPrecondition.check(child = parent.getChildAt(childIndex), parent, state)) continue;
            parent.getDecoratedBoundsWithMargins(child, this.mBounds);
            int right = this.mBounds.right + Math.round(child.getTranslationX());
            int left = right - this.mDividerThickness;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(canvas);
        }
        canvas.restore();
    }

    protected void onDrawVertically(@NonNull Canvas canvas, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        int right;
        int left;
        canvas.save();
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
            canvas.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
        } else {
            left = 0;
            right = parent.getWidth();
        }
        boolean hasRtlDirection = ViewCompat.getLayoutDirection((View)parent) == 1;
        left += hasRtlDirection ? this.mDividerOffsetEnd : this.mDividerOffsetStart;
        right += hasRtlDirection ? this.mDividerOffsetStart : this.mDividerOffsetEnd;
        int childCount = parent.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            View child;
            if (this.mSkipFirst && childIndex == 0 || this.mSkipLast && childIndex == childCount - 1 || !this.mPrecondition.check(child = parent.getChildAt(childIndex), parent, state)) continue;
            parent.getDecoratedBoundsWithMargins(child, this.mBounds);
            int bottom = this.mBounds.bottom + Math.round(child.getTranslationY());
            int top = bottom - this.mDividerThickness;
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(canvas);
        }
        canvas.restore();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Orientation {
    }
}

