/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference.crypto;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import universum.studios.android.crypto.Crypto;
import universum.studios.android.crypto.Decrypto;
import universum.studios.android.crypto.Encrypto;
import universum.studios.android.crypto.util.CryptographyUtils;
import universum.studios.android.preference.PreferencesLogging;
import universum.studios.android.preference.SharedPreferencesCache;

public final class CryptoSharedPreferences
implements SharedPreferences {
    private static final String TAG = "CryptoSharedPreferences";
    private final SharedPreferences delegate;
    private final CryptoHelper helper;
    private CryptoEditor editor;
    private final ChangeListenersRegistry changeListenersRegistry;
    private final AtomicBoolean changeListenersRegistered = new AtomicBoolean(false);
    private final SharedPreferencesCache cache;

    CryptoSharedPreferences(Builder builder) {
        this.delegate = builder.preferences;
        this.helper = new CryptoHelper(builder.keyCrypto, builder.valueCrypto);
        this.changeListenersRegistry = new ChangeListenersRegistry(this.helper, this);
        this.cache = builder.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        ChangeListenersRegistry changeListenersRegistry = this.changeListenersRegistry;
        synchronized (changeListenersRegistry) {
            this.changeListenersRegistry.register(listener);
            if (!this.changeListenersRegistered.get()) {
                this.delegate.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.changeListenersRegistry);
                this.changeListenersRegistered.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        ChangeListenersRegistry changeListenersRegistry = this.changeListenersRegistry;
        synchronized (changeListenersRegistry) {
            this.changeListenersRegistry.unregister(listener);
            if (this.changeListenersRegistry.isEmpty()) {
                this.delegate.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this.changeListenersRegistry);
                this.changeListenersRegistered.set(false);
            }
        }
    }

    public Map<String, ?> getAll() {
        Map encryptedValues = this.delegate.getAll();
        HashMap<String, Object> decryptedValues = new HashMap<String, Object>(encryptedValues.size());
        for (String key : encryptedValues.keySet()) {
            Object value = encryptedValues.get(key);
            String decryptedKey = this.helper.decryptKey(key);
            if (value == null) {
                decryptedValues.put(decryptedKey, null);
                continue;
            }
            if (value instanceof String) {
                decryptedValues.put(decryptedKey, this.helper.decryptValue(value.toString()));
                continue;
            }
            if (value instanceof Set) {
                decryptedValues.put(decryptedKey, this.helper.decryptValuesSet((Set)value));
                continue;
            }
            throw new IllegalStateException("Found encrypted value of unsupported type!");
        }
        return decryptedValues;
    }

    public boolean contains(@NonNull String key) {
        return this.delegate.contains(this.helper.encryptKey(key));
    }

    @Nullable
    public String getString(@NonNull String key, @Nullable String defValue) {
        if (this.cache == null || !this.cache.contains(key)) {
            String encryptedValue = this.delegate.getString(this.helper.encryptKey(key), defValue);
            if (CryptoHelper.areValuesEqual(encryptedValue, defValue)) {
                return defValue;
            }
            String decryptedValue = this.helper.decryptValue(encryptedValue);
            if (this.cache != null) {
                PreferencesLogging.d(TAG, "Putting String value for key(" + key + ") into cache.");
                this.cache.putString(key, decryptedValue);
            }
            return decryptedValue;
        }
        PreferencesLogging.d(TAG, "Retrieving String value for key(" + key + ") from the cache.");
        return this.cache.getString(key);
    }

    @Nullable
    public Set<String> getStringSet(@NonNull String key, @Nullable Set<String> defValues) {
        if (this.cache == null || !this.cache.contains(key)) {
            Set encryptedValues = this.delegate.getStringSet(this.helper.encryptKey(key), defValues);
            if (CryptoHelper.areValuesEqual(encryptedValues, defValues)) {
                return defValues;
            }
            Set<String> decryptedValues = this.helper.decryptValuesSet(encryptedValues);
            if (this.cache != null) {
                PreferencesLogging.d(TAG, "Putting Set<String> value for key(" + key + ") into cache.");
                this.cache.putStringSet(key, decryptedValues);
            }
            return decryptedValues;
        }
        PreferencesLogging.d(TAG, "Retrieving Set<String> value for key(" + key + ") from the cache.");
        return this.cache.getStringSet(key);
    }

    public int getInt(@NonNull String key, int defValue) {
        if (this.cache == null || !this.cache.contains(key)) {
            String defaultValue = Integer.toString(defValue);
            String encryptedValue = this.delegate.getString(this.helper.encryptKey(key), defaultValue);
            if (CryptoHelper.areValuesEqual(encryptedValue, defaultValue)) {
                return defValue;
            }
            int decryptedValue = Integer.parseInt(this.helper.decryptValue(encryptedValue));
            if (this.cache != null) {
                PreferencesLogging.d(TAG, "Putting int value for key(" + key + ") into cache.");
                this.cache.putInt(key, decryptedValue);
            }
            return decryptedValue;
        }
        PreferencesLogging.d(TAG, "Retrieving int value for key(" + key + ") from the cache.");
        return this.cache.getInt(key);
    }

    public long getLong(@NonNull String key, long defValue) {
        if (this.cache == null || !this.cache.contains(key)) {
            String defaultValue = Long.toString(defValue);
            String encryptedValue = this.delegate.getString(this.helper.encryptKey(key), defaultValue);
            if (CryptoHelper.areValuesEqual(encryptedValue, defaultValue)) {
                return defValue;
            }
            long decryptedValue = Long.parseLong(this.helper.decryptValue(encryptedValue));
            if (this.cache != null) {
                PreferencesLogging.d(TAG, "Putting long value for key(" + key + ") into cache.");
                this.cache.putLong(key, decryptedValue);
            }
            return decryptedValue;
        }
        PreferencesLogging.d(TAG, "Retrieving long value for key(" + key + ") from the cache.");
        return this.cache.getLong(key);
    }

    public float getFloat(@NonNull String key, float defValue) {
        if (this.cache == null || !this.cache.contains(key)) {
            String defaultValue = Float.toString(defValue);
            String encryptedValue = this.delegate.getString(this.helper.encryptKey(key), defaultValue);
            if (CryptoHelper.areValuesEqual(encryptedValue, defaultValue)) {
                return defValue;
            }
            float decryptedValue = Float.parseFloat(this.helper.decryptValue(encryptedValue));
            if (this.cache != null) {
                PreferencesLogging.d(TAG, "Putting float value for key(" + key + ") into cache.");
                this.cache.putFloat(key, decryptedValue);
            }
            return decryptedValue;
        }
        PreferencesLogging.d(TAG, "Retrieving float value for key(" + key + ") from the cache.");
        return this.cache.getFloat(key);
    }

    public boolean getBoolean(@NonNull String key, boolean defValue) {
        if (this.cache == null || !this.cache.contains(key)) {
            String defaultValue = Boolean.toString(defValue);
            String encryptedValue = this.delegate.getString(this.helper.encryptKey(key), defaultValue);
            if (CryptoHelper.areValuesEqual(encryptedValue, defaultValue)) {
                return defValue;
            }
            boolean decryptedValue = Boolean.parseBoolean(this.helper.decryptValue(encryptedValue));
            if (this.cache != null) {
                PreferencesLogging.d(TAG, "Putting boolean value for key(" + key + ") into cache.");
                this.cache.putBoolean(key, decryptedValue);
            }
            return decryptedValue;
        }
        PreferencesLogging.d(TAG, "Retrieving boolean value for key(" + key + ") from the cache.");
        return this.cache.getBoolean(key);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    public SharedPreferences.Editor edit() {
        if (this.editor == null) {
            this.editor = new CryptoEditor(this.helper, this.delegate.edit());
            this.editor.setCache(this.cache);
        }
        return this.editor;
    }

    @VisibleForTesting
    static final class ChangeListenersRegistry
    implements SharedPreferences.OnSharedPreferenceChangeListener {
        private final CryptoHelper helper;
        private final SharedPreferences cryptoPreferences;
        private final List<SharedPreferences.OnSharedPreferenceChangeListener> listeners = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>(2);

        ChangeListenersRegistry(CryptoHelper helper, SharedPreferences cryptoPreferences) {
            this.helper = helper;
            this.cryptoPreferences = cryptoPreferences;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void register(SharedPreferences.OnSharedPreferenceChangeListener listener) {
            List<SharedPreferences.OnSharedPreferenceChangeListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.contains(listener)) {
                    this.listeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void unregister(SharedPreferences.OnSharedPreferenceChangeListener listener) {
            List<SharedPreferences.OnSharedPreferenceChangeListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }

        boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSharedPreferenceChanged(@NonNull SharedPreferences sharedPreferences, @NonNull String key) {
            List<SharedPreferences.OnSharedPreferenceChangeListener> list = this.listeners;
            synchronized (list) {
                if (!this.listeners.isEmpty()) {
                    String decryptedKey = this.helper.decryptKey(key);
                    PreferencesLogging.d(CryptoSharedPreferences.TAG, "Changed preference with key(encrypted: " + key + ", decrypted: " + decryptedKey + ").");
                    for (SharedPreferences.OnSharedPreferenceChangeListener listener : this.listeners) {
                        listener.onSharedPreferenceChanged(this.cryptoPreferences, decryptedKey);
                    }
                }
            }
        }
    }

    @VisibleForTesting
    static final class CryptoEditor
    implements SharedPreferences.Editor {
        private final CryptoHelper helper;
        private final SharedPreferences.Editor delegate;
        private SharedPreferencesCache cache;

        CryptoEditor(CryptoHelper helper, SharedPreferences.Editor delegate) {
            this.delegate = delegate;
            this.helper = helper;
        }

        void setCache(SharedPreferencesCache cache) {
            this.cache = cache;
        }

        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            return this.putEncryptedValue(key, this.helper.encryptValue(value));
        }

        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            this.invalidateCachedValue(key);
            this.delegate.putStringSet(this.helper.encryptKey(key), this.helper.encryptValuesSet(values));
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            return this.putEncryptedValue(key, this.helper.encryptValue(Integer.toString(value)));
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            return this.putEncryptedValue(key, this.helper.encryptValue(Long.toString(value)));
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            return this.putEncryptedValue(key, this.helper.encryptValue(Float.toString(value)));
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            return this.putEncryptedValue(key, this.helper.encryptValue(Boolean.toString(value)));
        }

        private SharedPreferences.Editor putEncryptedValue(String key, @Nullable String value) {
            this.invalidateCachedValue(key);
            this.delegate.putString(this.helper.encryptKey(key), value);
            return this;
        }

        private void invalidateCachedValue(String key) {
            if (this.cache != null) {
                this.cache.evict(key);
            }
        }

        public SharedPreferences.Editor remove(String key) {
            this.delegate.remove(key);
            return this;
        }

        public SharedPreferences.Editor clear() {
            this.delegate.clear();
            return this;
        }

        public boolean commit() {
            return this.delegate.commit();
        }

        public void apply() {
            this.delegate.apply();
        }
    }

    @VisibleForTesting
    static class CryptoHelper {
        private final Crypto keyCrypto;
        private final Crypto valueCrypto;

        CryptoHelper(Crypto keyCrypto, Crypto valueCrypto) {
            this.keyCrypto = keyCrypto;
            this.valueCrypto = valueCrypto;
        }

        static boolean areValuesEqual(Object firstValue, Object secondValue) {
            return firstValue == null && secondValue == null || firstValue != null && firstValue.equals(secondValue);
        }

        String encryptKey(String key) {
            return this.keyCrypto == null ? key : CryptographyUtils.encrypt((String)key, (Encrypto)this.keyCrypto);
        }

        String decryptKey(String key) {
            return this.keyCrypto == null ? key : CryptographyUtils.decrypt((String)key, (Decrypto)this.keyCrypto);
        }

        String encryptValue(String value) {
            return this.valueCrypto == null ? value : CryptographyUtils.encrypt((String)value, (Encrypto)this.valueCrypto);
        }

        String decryptValue(String value) {
            return this.valueCrypto == null ? value : CryptographyUtils.decrypt((String)value, (Decrypto)this.valueCrypto);
        }

        Set<String> encryptValuesSet(Set<String> values) {
            if (this.valueCrypto == null || values == null) {
                return values;
            }
            HashSet<String> encryptedValues = new HashSet<String>(values.size());
            for (String value : values) {
                encryptedValues.add(this.encryptValue(value));
            }
            return encryptedValues;
        }

        Set<String> decryptValuesSet(Set<String> values) {
            if (this.valueCrypto == null || values == null) {
                return values;
            }
            HashSet<String> decryptedValues = new HashSet<String>(values.size());
            for (String value : values) {
                decryptedValues.add(this.decryptValue(value));
            }
            return decryptedValues;
        }
    }

    public static final class Builder {
        final SharedPreferences preferences;
        Crypto keyCrypto;
        Crypto valueCrypto;
        SharedPreferencesCache cache;

        public Builder(@NonNull SharedPreferences preferences) {
            this.preferences = preferences;
        }

        public Builder keyCrypto(@Nullable Crypto crypto) {
            this.keyCrypto = crypto;
            return this;
        }

        public Builder valueCrypto(@NonNull Crypto crypto) {
            this.valueCrypto = crypto;
            return this;
        }

        public Builder valueCache(@Nullable SharedPreferencesCache cache) {
            this.cache = cache;
            return this;
        }

        @NonNull
        public CryptoSharedPreferences build() {
            if (this.valueCrypto == null) {
                throw new IllegalArgumentException("No Crypto implementation for values encryption/decryption specified.");
            }
            return new CryptoSharedPreferences(this);
        }
    }
}

