/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public abstract class SharedPreference<T> {
    final String key;
    T defaultValue;
    T value;
    boolean valueIsActual;

    protected SharedPreference(@NonNull String key, @Nullable T defValue) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Preference key cannot be empty.");
        }
        this.key = key;
        this.value = defValue;
        this.defaultValue = this.value;
    }

    @NonNull
    public final String getKey() {
        return this.key;
    }

    @NonNull
    public SharedPreferences.OnSharedPreferenceChangeListener createOnChangeListener(final @NonNull PreferenceChangeCallback<T> callback) {
        return new SharedPreferences.OnSharedPreferenceChangeListener(){

            public void onSharedPreferenceChanged(@NonNull SharedPreferences sharedPreferences, @NonNull String key) {
                if (SharedPreference.this.key.equals(key)) {
                    SharedPreference.this.valueIsActual = false;
                    SharedPreference.this.getFromPreferences(sharedPreferences);
                    callback.onPreferenceChanged(SharedPreference.this);
                }
            }
        };
    }

    @Nullable
    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public SharedPreference<T> updateValue(@Nullable T newValue) {
        if (this.value == null || !this.value.equals(newValue)) {
            this.value = newValue;
            this.valueIsActual = true;
        }
        return this;
    }

    public final boolean putIntoPreferences(@NonNull SharedPreferences preferences) {
        this.valueIsActual = this.onPutIntoPreferences(preferences);
        return this.valueIsActual;
    }

    @CheckResult
    protected abstract boolean onPutIntoPreferences(@NonNull SharedPreferences var1);

    @Nullable
    public final T getValue() {
        return this.value;
    }

    @Nullable
    final T getFromPreferences(SharedPreferences preferences) {
        if (!this.valueIsActual) {
            this.value = this.onGetFromPreferences(preferences);
            this.valueIsActual = true;
        }
        return this.value;
    }

    @Nullable
    protected abstract T onGetFromPreferences(@NonNull SharedPreferences var1);

    final void invalidate() {
        this.value = null;
        this.valueIsActual = false;
    }

    public static interface PreferenceChangeCallback<P> {
        public void onPreferenceChanged(@NonNull SharedPreference<P> var1);
    }
}

