/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import androidx.annotation.NonNull;

public interface SharedPreferencesFactory {
    public static final SharedPreferencesFactory DEFAULT = new SharedPreferencesFactory(){

        @Override
        @NonNull
        public SharedPreferences createPreferences(@NonNull Context context) {
            return PreferenceManager.getDefaultSharedPreferences((Context)context);
        }
    };

    @NonNull
    public SharedPreferences createPreferences(@NonNull Context var1);

    public static class SimpleFactory
    implements SharedPreferencesFactory {
        private final String fileName;
        private final int fileMode;

        public SimpleFactory(@NonNull String fileName) {
            this(fileName, 0);
        }

        public SimpleFactory(@NonNull String fileName, int fileMode) {
            this.fileName = fileName;
            this.fileMode = fileMode;
        }

        @Override
        @NonNull
        public SharedPreferences createPreferences(@NonNull Context context) {
            return context.getSharedPreferences(this.fileName, this.fileMode);
        }
    }
}

