/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.SharedPreferences;
import android.text.TextUtils;
import androidx.annotation.CheckResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import universum.studios.android.preference.SharedPreference;

public final class EnumPreference<E extends Enum>
extends SharedPreference<E> {
    public EnumPreference(@NonNull String key, @NonNull E defValue) {
        super(key, defValue);
    }

    @Override
    @CheckResult
    protected boolean onPutIntoPreferences(@NonNull SharedPreferences preferences) {
        return preferences.edit().putString(this.key, this.value == null ? "" : ((Enum)this.value).name()).commit();
    }

    @Override
    @Nullable
    protected E onGetFromPreferences(@NonNull SharedPreferences preferences) {
        String enumName = preferences.getString(this.key, ((Enum)this.defaultValue).name());
        return TextUtils.isEmpty((CharSequence)enumName) ? null : (E)Enum.valueOf(((Enum)this.defaultValue).getClass(), enumName);
    }
}

