/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import universum.studios.android.preference.SharedPreferencesCache;

final class MapCache
implements SharedPreferencesCache {
    private final Map<String, Object> map = new HashMap<String, Object>();

    MapCache() {
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(@NonNull String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean putString(@NonNull String key, @Nullable String value) {
        this.map.put(key, value);
        return true;
    }

    @Override
    @Nullable
    public String getString(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (String)this.map.get(key);
    }

    @Override
    public boolean putStringSet(@NonNull String key, @Nullable Set<String> values) {
        this.map.put(key, values);
        return true;
    }

    @Override
    @Nullable
    public Set<String> getStringSet(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (Set)this.map.get(key);
    }

    @Override
    public boolean putInt(@NonNull String key, int value) {
        this.map.put(key, value);
        return true;
    }

    @Override
    public int getInt(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (Integer)this.map.get(key);
    }

    @Override
    public boolean putFloat(@NonNull String key, float value) {
        this.map.put(key, Float.valueOf(value));
        return true;
    }

    @Override
    public float getFloat(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return ((Float)this.map.get(key)).floatValue();
    }

    @Override
    public boolean putLong(@NonNull String key, long value) {
        this.map.put(key, value);
        return true;
    }

    @Override
    public long getLong(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (Long)this.map.get(key);
    }

    @Override
    public boolean putBoolean(@NonNull String key, boolean value) {
        this.map.put(key, value);
        return true;
    }

    @Override
    public boolean getBoolean(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (Boolean)this.map.get(key);
    }

    private void assertContainsOrThrow(String key) {
        if (!this.map.containsKey(key)) {
            throw new SharedPreferencesCache.NotInCacheException(key);
        }
    }

    @Override
    public boolean evict(@NonNull String key) {
        if (this.map.containsKey(key)) {
            this.map.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public int evictAll() {
        int size = this.map.size();
        if (size > 0) {
            this.map.clear();
        }
        return size;
    }
}

