/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import java.util.Set;
import universum.studios.android.preference.SharedPreference;
import universum.studios.android.preference.SharedPreferencesFacade;
import universum.studios.android.preference.SharedPreferencesPolicies;
import universum.studios.android.preference.SharedPreferencesProvider;
import universum.studios.android.preference.SimpleSharedPreferencesFacade;

public class PreferencesManager
implements SharedPreferencesFacade,
SharedPreferencesProvider {
    private final Context context;
    private String preferencesName;
    private int preferencesMode = 0;
    private SimpleSharedPreferencesFacade preferencesFacade;
    private boolean cachingEnabled;

    public PreferencesManager(@NonNull Context context) {
        this.context = context;
        this.preferencesName = SharedPreferencesPolicies.defaultPreferencesName(context);
    }

    @NonNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    public void setSharedPreferencesName(@Nullable String name) {
        this.preferencesName = name == null ? SharedPreferencesPolicies.defaultPreferencesName(this.context) : name;
        this.preferencesFacade = null;
    }

    @Override
    @NonNull
    public final String getSharedPreferencesName() {
        return this.preferencesName;
    }

    @Override
    public void setSharedPreferencesMode(int mode) {
        this.preferencesMode = mode;
        this.preferencesFacade = null;
    }

    @Override
    public final int getSharedPreferencesMode() {
        return this.preferencesMode;
    }

    @Override
    @NonNull
    public final SharedPreferences getSharedPreferences() {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.getPreferences();
    }

    private void ensurePreferencesFacade() {
        if (this.preferencesFacade == null) {
            this.preferencesFacade = new SimpleSharedPreferencesFacade(this.context.getSharedPreferences(this.preferencesName, this.preferencesMode));
        }
    }

    public final void setCachingEnabled(boolean enabled) {
        this.cachingEnabled = enabled;
    }

    public final boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    @NonNull
    public final String key(@StringRes int resId) {
        return this.context.getString(resId);
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.ensurePreferencesFacade();
        this.preferencesFacade.registerOnSharedPreferenceChangeListener(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.ensurePreferencesFacade();
        this.preferencesFacade.unregisterOnSharedPreferenceChangeListener(listener);
    }

    @Override
    public boolean contains(@NonNull String key) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.contains(key);
    }

    @Override
    public boolean putString(@NonNull String key, @Nullable String value) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.putString(key, value);
    }

    @Override
    @Nullable
    public String getString(@NonNull String key, @Nullable String defValue) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.getString(key, defValue);
    }

    @Override
    public boolean putStringSet(@NonNull String key, @Nullable Set<String> values) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.putStringSet(key, values);
    }

    @Override
    @Nullable
    public Set<String> getStringSet(@NonNull String key, @Nullable Set<String> defValues) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.getStringSet(key, defValues);
    }

    @Override
    public boolean putInt(@NonNull String key, int value) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.putInt(key, value);
    }

    @Override
    public int getInt(@NonNull String key, int defValue) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.getInt(key, defValue);
    }

    @Override
    public boolean putFloat(@NonNull String key, float value) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.putFloat(key, value);
    }

    @Override
    public float getFloat(@NonNull String key, float defValue) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.getFloat(key, defValue);
    }

    @Override
    public boolean putLong(@NonNull String key, long value) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.putLong(key, value);
    }

    @Override
    public long getLong(@NonNull String key, long defValue) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.getLong(key, defValue);
    }

    @Override
    public boolean putBoolean(@NonNull String key, boolean value) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.putBoolean(key, value);
    }

    @Override
    public boolean getBoolean(@NonNull String key, boolean defValue) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.getBoolean(key, defValue);
    }

    @Override
    public boolean remove(@NonNull String key) {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.remove(key);
    }

    @Override
    public int removeAll() {
        this.ensurePreferencesFacade();
        return this.preferencesFacade.removeAll();
    }

    public final <T> boolean putPreference(@NonNull SharedPreference<T> preference, @Nullable T value) {
        this.ensurePreferencesFacade();
        boolean result = preference.updateValue(value).putIntoPreferences(this.preferencesFacade.getPreferences());
        if (!this.cachingEnabled) {
            preference.invalidate();
        }
        return result;
    }

    @Nullable
    public final <T> T getPreference(@NonNull SharedPreference<T> preference) {
        this.ensurePreferencesFacade();
        T value = preference.getFromPreferences(this.preferencesFacade.getPreferences());
        if (!this.cachingEnabled) {
            preference.invalidate();
        }
        return value;
    }

    public final boolean containsPreference(@NonNull SharedPreference preference) {
        return this.contains(preference.getKey());
    }

    public final boolean removePreference(@NonNull SharedPreference preference) {
        return this.remove(preference.getKey());
    }
}

