/*
 * *************************************************************************************************
 *                                 Copyright 2017 Universum Studios
 * *************************************************************************************************
 *                  Licensed under the Apache License, Version 2.0 (the "License")
 * -------------------------------------------------------------------------------------------------
 * You may not use this file except in compliance with the License. You may obtain a copy of the
 * License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * See the License for the specific language governing permissions and limitations under the License.
 * *************************************************************************************************
 */
package universum.studios.android.preference.cache;

import android.support.annotation.NonNull;

import universum.studios.android.preference.SharedPreferencesCache;

/**
 * Factory that provides common implementations of {@link SharedPreferencesCache}.
 * <ul>
 * <li>{@link #mapCache()}</li>
 * </ul>
 *
 * @author Martin Albedinsky
 * @since 2.0
 */
public final class SharedPreferenceCaches {

	/**
	 */
	private SharedPreferenceCaches() {
		// Not allowed to be instantiated publicly.
		throw new UnsupportedOperationException();
	}

	/**
	 * Returns a new instance of {@link SharedPreferencesCache} that is backed by implementation of
	 * {@link java.util.Map Map}.
	 *
	 * @return Preferences cache ready to be used.
	 */
	@NonNull public static SharedPreferencesCache mapCache() {
		return new MapCache();
	}
}