/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import universum.studios.android.preference.SharedPreferencesCache;

final class MapCache
implements SharedPreferencesCache {
    private final Map<String, Object> mMap = new HashMap<String, Object>();

    MapCache() {
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    @Override
    public boolean contains(@NonNull String key) {
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean putString(@NonNull String key, @Nullable String value) {
        this.mMap.put(key, value);
        return true;
    }

    @Override
    @Nullable
    public String getString(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (String)this.mMap.get(key);
    }

    @Override
    public boolean putStringSet(@NonNull String key, @Nullable Set<String> values) {
        this.mMap.put(key, values);
        return true;
    }

    @Override
    @Nullable
    public Set<String> getStringSet(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (Set)this.mMap.get(key);
    }

    @Override
    public boolean putInt(@NonNull String key, int value) {
        this.mMap.put(key, value);
        return true;
    }

    @Override
    public int getInt(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (Integer)this.mMap.get(key);
    }

    @Override
    public boolean putFloat(@NonNull String key, float value) {
        this.mMap.put(key, Float.valueOf(value));
        return true;
    }

    @Override
    public float getFloat(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return ((Float)this.mMap.get(key)).floatValue();
    }

    @Override
    public boolean putLong(@NonNull String key, long value) {
        this.mMap.put(key, value);
        return true;
    }

    @Override
    public long getLong(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (Long)this.mMap.get(key);
    }

    @Override
    public boolean putBoolean(@NonNull String key, boolean value) {
        this.mMap.put(key, value);
        return true;
    }

    @Override
    public boolean getBoolean(@NonNull String key) {
        this.assertContainsOrThrow(key);
        return (Boolean)this.mMap.get(key);
    }

    private void assertContainsOrThrow(String key) {
        if (!this.mMap.containsKey(key)) {
            throw new SharedPreferencesCache.NotInCacheException(key);
        }
    }

    @Override
    public boolean evict(@NonNull String key) {
        if (this.mMap.containsKey(key)) {
            this.mMap.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public int evictAll() {
        int size = this.mMap.size();
        if (size > 0) {
            this.mMap.clear();
        }
        return size;
    }
}

