/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.SharedPreferences;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;

public abstract class SharedPreference<T> {
    final String mKey;
    T mDefaultValue;
    T mValue;
    boolean mValueIsActual;

    protected SharedPreference(@NonNull String key, @Nullable T defValue) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Preference key cannot be empty.");
        }
        this.mKey = key;
        this.mValue = defValue;
        this.mDefaultValue = this.mValue;
    }

    @NonNull
    public final String getKey() {
        return this.mKey;
    }

    @NonNull
    public SharedPreferences.OnSharedPreferenceChangeListener createOnChangeListener(final @NonNull PreferenceChangeCallback<T> callback) {
        return new SharedPreferences.OnSharedPreferenceChangeListener(){

            public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                if (SharedPreference.this.mKey.equals(key)) {
                    SharedPreference.this.mValueIsActual = false;
                    SharedPreference.this.getFromPreferences(sharedPreferences);
                    callback.onPreferenceChanged(SharedPreference.this);
                }
            }
        };
    }

    @Nullable
    public final T getDefaultValue() {
        return this.mDefaultValue;
    }

    public SharedPreference<T> updateValue(@Nullable T newValue) {
        if (this.mValue == null || !this.mValue.equals(newValue)) {
            this.mValue = newValue;
            this.mValueIsActual = true;
        }
        return this;
    }

    public final boolean putIntoPreferences(@NonNull SharedPreferences preferences) {
        this.mValueIsActual = this.onPutIntoPreferences(preferences);
        return this.mValueIsActual;
    }

    @CheckResult
    protected abstract boolean onPutIntoPreferences(@NonNull SharedPreferences var1);

    @Nullable
    public final T getValue() {
        return this.mValue;
    }

    final T getFromPreferences(SharedPreferences preferences) {
        if (!this.mValueIsActual) {
            this.mValue = this.onGetFromPreferences(preferences);
            this.mValueIsActual = true;
        }
        return this.mValue;
    }

    @Nullable
    protected abstract T onGetFromPreferences(@NonNull SharedPreferences var1);

    final void invalidate() {
        this.mValue = null;
        this.mValueIsActual = false;
    }

    public static interface PreferenceChangeCallback<P> {
        public void onPreferenceChanged(@NonNull SharedPreference<P> var1);
    }
}

