/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import java.util.Set;
import universum.studios.android.preference.SharedPreference;
import universum.studios.android.preference.SharedPreferencesFacade;
import universum.studios.android.preference.SharedPreferencesPolicies;
import universum.studios.android.preference.SharedPreferencesProvider;
import universum.studios.android.preference.SimpleSharedPreferencesFacade;

public class PreferencesManager
implements SharedPreferencesFacade,
SharedPreferencesProvider {
    private final Context mContext;
    private String mPreferencesName;
    private int mPreferencesMode = 0;
    private SimpleSharedPreferencesFacade mPreferencesFacade;
    private boolean mCachingEnabled;

    public PreferencesManager(@NonNull Context context) {
        this.mContext = context;
        this.mPreferencesName = SharedPreferencesPolicies.defaultPreferencesName(context);
    }

    @NonNull
    public final Context getContext() {
        return this.mContext;
    }

    @Override
    public void setSharedPreferencesName(@Nullable String name) {
        this.mPreferencesName = name == null ? SharedPreferencesPolicies.defaultPreferencesName(this.mContext) : name;
        this.mPreferencesFacade = null;
    }

    @Override
    @NonNull
    public final String getSharedPreferencesName() {
        return this.mPreferencesName;
    }

    @Override
    public void setSharedPreferencesMode(int mode) {
        this.mPreferencesMode = mode;
        this.mPreferencesFacade = null;
    }

    @Override
    public final int getSharedPreferencesMode() {
        return this.mPreferencesMode;
    }

    @Override
    @NonNull
    public final SharedPreferences getSharedPreferences() {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.getPreferences();
    }

    private void ensurePreferencesFacade() {
        if (this.mPreferencesFacade == null) {
            this.mPreferencesFacade = new SimpleSharedPreferencesFacade(this.mContext.getSharedPreferences(this.mPreferencesName, this.mPreferencesMode));
        }
    }

    public final void setCachingEnabled(boolean enabled) {
        this.mCachingEnabled = enabled;
    }

    public final boolean isCachingEnabled() {
        return this.mCachingEnabled;
    }

    @NonNull
    public final String key(@StringRes int resId) {
        return this.mContext.getString(resId);
    }

    @Override
    public void registerOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.ensurePreferencesFacade();
        this.mPreferencesFacade.registerOnSharedPreferenceChangeListener(listener);
    }

    @Override
    public void unregisterOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.ensurePreferencesFacade();
        this.mPreferencesFacade.unregisterOnSharedPreferenceChangeListener(listener);
    }

    @Override
    public boolean contains(@NonNull String key) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.contains(key);
    }

    @Override
    public boolean putString(@NonNull String key, @Nullable String value) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.putString(key, value);
    }

    @Override
    @Nullable
    public String getString(@NonNull String key, @Nullable String defValue) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.getString(key, defValue);
    }

    @Override
    public boolean putStringSet(@NonNull String key, @Nullable Set<String> values) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.putStringSet(key, values);
    }

    @Override
    @Nullable
    public Set<String> getStringSet(@NonNull String key, @Nullable Set<String> defValues) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.getStringSet(key, defValues);
    }

    @Override
    public boolean putInt(@NonNull String key, int value) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.putInt(key, value);
    }

    @Override
    public int getInt(@NonNull String key, int defValue) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.getInt(key, defValue);
    }

    @Override
    public boolean putFloat(@NonNull String key, float value) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.putFloat(key, value);
    }

    @Override
    public float getFloat(@NonNull String key, float defValue) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.getFloat(key, defValue);
    }

    @Override
    public boolean putLong(@NonNull String key, long value) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.putLong(key, value);
    }

    @Override
    public long getLong(@NonNull String key, long defValue) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.getLong(key, defValue);
    }

    @Override
    public boolean putBoolean(@NonNull String key, boolean value) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.putBoolean(key, value);
    }

    @Override
    public boolean getBoolean(@NonNull String key, boolean defValue) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.getBoolean(key, defValue);
    }

    @Override
    public boolean remove(@NonNull String key) {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.remove(key);
    }

    @Override
    public int removeAll() {
        this.ensurePreferencesFacade();
        return this.mPreferencesFacade.removeAll();
    }

    public final <T> boolean putPreference(@NonNull SharedPreference<T> preference, @Nullable T value) {
        this.ensurePreferencesFacade();
        boolean result = preference.updateValue(value).putIntoPreferences(this.mPreferencesFacade.getPreferences());
        if (!this.mCachingEnabled) {
            preference.invalidate();
        }
        return result;
    }

    @Nullable
    public final <T> T getPreference(@NonNull SharedPreference<T> preference) {
        this.ensurePreferencesFacade();
        T value = preference.getFromPreferences(this.mPreferencesFacade.getPreferences());
        if (!this.mCachingEnabled) {
            preference.invalidate();
        }
        return value;
    }

    public final boolean containsPreference(@NonNull SharedPreference preference) {
        return this.contains(preference.getKey());
    }

    public final boolean removePreference(@NonNull SharedPreference preference) {
        return this.remove(preference.getKey());
    }
}

