/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.SharedPreferences;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import universum.studios.android.preference.ArrayPreference;
import universum.studios.android.preference.SharedPreference;

public final class CollectionPreference<T>
extends SharedPreference<Collection<T>> {
    private final Class<T> mComponentType;

    public CollectionPreference(@NonNull String key, @NonNull Class<T> componentType, @Nullable Collection<T> defValue) {
        super(key, defValue);
        this.mComponentType = componentType;
    }

    @Override
    @CheckResult
    protected boolean onPutIntoPreferences(@NonNull SharedPreferences preferences) {
        return CollectionPreference.putIntoPreferences(preferences, this.mKey, (Collection)this.mValue, this.mComponentType);
    }

    @CheckResult
    public static <T> boolean putIntoPreferences(@NonNull SharedPreferences preferences, @NonNull String key, @Nullable Collection<T> value, @NonNull Class<T> componentType) {
        SharedPreferences.Editor editor = preferences.edit();
        if (value != null) {
            Object[] array = (Object[])ArrayPreference.createArrayInSize(componentType, value.size());
            if (array == null) {
                String componentName = componentType.getSimpleName();
                throw new IllegalArgumentException("Failed to put collection of(" + componentName + ") into shared preferences. Only collections of primitive types or theirs boxed representations including String are supported.");
            }
            value.toArray(array);
            return ArrayPreference.putIntoPreferences(preferences, key, array);
        }
        editor.putString(key, null);
        return editor.commit();
    }

    @Override
    @Nullable
    protected Collection<T> onGetFromPreferences(@NonNull SharedPreferences preferences) {
        return CollectionPreference.getFromPreferences(preferences, this.mKey, (Collection)this.mDefaultValue);
    }

    public static <T> Collection<T> getFromPreferences(@NonNull SharedPreferences preferences, @NonNull String key, @Nullable Collection<T> defValue) {
        String value = preferences.getString(key, null);
        if (value != null) {
            try {
                Object[] array = (Object[])ArrayPreference.getFromPreferences(preferences, key, null);
                return Arrays.asList(array);
            }
            catch (ClassCastException e) {
                String arrayValue = ArrayPreference.extractArrayElementsFromPreferenceValue(value);
                throw new ClassCastException("Cannot obtain a collection for the key(" + key + ") from shared preferences. Value(" + arrayValue + ") is not a collection!");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to obtain collection for the key(" + key + ") from shared preferences. Only collections of primitive types or theirs boxed representations including String are supported.");
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Trying to obtain a collection for the key(" + key + ") from shared preferences not saved by the Preferences library.");
            }
        }
        return defValue;
    }
}

