/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.SharedPreferences;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import java.lang.reflect.Array;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import universum.studios.android.preference.SharedPreference;

public final class ArrayPreference<T>
extends SharedPreference<T> {
    private static final Pattern VALUE_PATTERN = Pattern.compile("^\\<(.+)\\[\\]\\>\\[(.*)\\]$");

    public ArrayPreference(@NonNull String key, @Nullable T defValue) {
        super(key, defValue);
        ArrayPreference.assertIsArrayOrThrow(defValue);
    }

    private static void assertIsArrayOrThrow(Object value) {
        if (value != null && !value.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array(" + value.getClass().getSimpleName() + ").");
        }
    }

    @Override
    @CheckResult
    protected boolean onPutIntoPreferences(@NonNull SharedPreferences preferences) {
        return ArrayPreference.putIntoPreferences(preferences, this.mKey, this.mValue);
    }

    @CheckResult
    public static boolean putIntoPreferences(@NonNull SharedPreferences preferences, @NonNull String key, @Nullable Object value) {
        if (value == null) {
            return preferences.edit().putString(key, null).commit();
        }
        ArrayPreference.assertIsArrayOrThrow(value);
        int n = Array.getLength(value);
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < n; ++i) {
            jsonArray.put(Array.get(value, i));
        }
        Class<?> arrayClass = ArrayPreference.resolveArrayClass(value);
        if (arrayClass == null) {
            String componentName = value.getClass().getComponentType().getSimpleName();
            throw new IllegalArgumentException("Failed to put array of(" + componentName + ") into shared preferences. Only arrays of primitive types or theirs boxed representations including String are supported.");
        }
        return preferences.edit().putString(key, "<" + arrayClass.getSimpleName() + ">" + jsonArray.toString()).commit();
    }

    static Class<?> resolveArrayClass(Object array) {
        if (array instanceof boolean[]) {
            return boolean[].class;
        }
        if (array instanceof byte[]) {
            return byte[].class;
        }
        if (array instanceof char[]) {
            return char[].class;
        }
        if (array instanceof short[]) {
            return short[].class;
        }
        if (array instanceof int[]) {
            return int[].class;
        }
        if (array instanceof float[]) {
            return float[].class;
        }
        if (array instanceof long[]) {
            return long[].class;
        }
        if (array instanceof double[]) {
            return double[].class;
        }
        if (array instanceof Byte[]) {
            return Byte[].class;
        }
        if (array instanceof Character[]) {
            return Character[].class;
        }
        if (array instanceof Short[]) {
            return Short[].class;
        }
        if (array instanceof Integer[]) {
            return Integer[].class;
        }
        if (array instanceof Float[]) {
            return Float[].class;
        }
        if (array instanceof Long[]) {
            return Long[].class;
        }
        if (array instanceof Double[]) {
            return Double[].class;
        }
        if (array instanceof Boolean[]) {
            return Boolean[].class;
        }
        if (array instanceof String[]) {
            return String[].class;
        }
        return null;
    }

    @Override
    @Nullable
    protected T onGetFromPreferences(@NonNull SharedPreferences preferences) {
        return (T)ArrayPreference.getFromPreferences(preferences, this.mKey, this.mDefaultValue);
    }

    @Nullable
    public static <A> A getFromPreferences(@NonNull SharedPreferences preferences, @NonNull String key, @Nullable Object defValue) {
        String value = preferences.getString(key, null);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return (A)defValue;
        }
        Object array = defValue;
        Matcher valueMatcher = VALUE_PATTERN.matcher(value);
        if (valueMatcher.reset(value).matches()) {
            JSONArray jsonArray;
            String arrayClassName = valueMatcher.group(1) + "[]";
            Class<?> arrayClass = ArrayPreference.resolveArrayClassByName(arrayClassName);
            if (arrayClass == null) {
                String componentName = arrayClassName.substring(0, arrayClassName.length() - 2);
                throw new IllegalArgumentException("Failed to obtain an array of(" + componentName + ") for the key(" + key + ") from shared preferences. Only arrays of primitive types or theirs boxed representations including String are supported.");
            }
            String jsonArrayValue = "[" + valueMatcher.group(2) + "]";
            try {
                jsonArray = new JSONArray(jsonArrayValue);
            }
            catch (JSONException e) {
                throw new ClassCastException("Cannot obtain an array for the key(" + key + ") from shared preferences. Value(" + jsonArrayValue + ") is not an array!");
            }
            int n = jsonArray.length();
            array = ArrayPreference.createArrayInSize(arrayClass.getComponentType(), n);
            for (int i = 0; i < n; ++i) {
                ArrayPreference.setArrayValueAt(arrayClass, array, i, jsonArray.opt(i));
            }
        } else {
            throw new IllegalStateException("Trying to obtain an array for the key(" + key + ") from shared preferences not saved by the Preferences library.");
        }
        return (A)array;
    }

    @Nullable
    static String extractArrayElementsFromPreferenceValue(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        Matcher matcher = VALUE_PATTERN.matcher(value);
        return matcher.matches() ? matcher.group(2) : null;
    }

    @VisibleForTesting
    static void setArrayValueAt(Class<?> arrayClass, Object array, int index, Object value) {
        if (value == null) {
            Array.set(array, index, null);
            return;
        }
        if (byte[].class.equals(arrayClass) || Byte[].class.equals(arrayClass)) {
            Array.set(array, index, Byte.valueOf(value.toString()));
        } else if (char[].class.equals(arrayClass) || Character[].class.equals(arrayClass)) {
            Array.set(array, index, Character.valueOf(value.toString().charAt(0)));
        } else if (short[].class.equals(arrayClass) || Short[].class.equals(arrayClass)) {
            Array.set(array, index, Short.valueOf(value.toString()));
        } else if (float[].class.equals(arrayClass) || Float[].class.equals(arrayClass)) {
            Array.set(array, index, Float.valueOf(value.toString()));
        } else if (long[].class.equals(arrayClass) || Long[].class.equals(arrayClass)) {
            Array.set(array, index, Long.valueOf(value.toString()));
        } else {
            Array.set(array, index, value);
        }
    }

    static Class<?> resolveArrayClassByName(String arrayClassName) {
        switch (arrayClassName) {
            case "byte[]": {
                return byte[].class;
            }
            case "char[]": {
                return char[].class;
            }
            case "short[]": {
                return short[].class;
            }
            case "int[]": {
                return int[].class;
            }
            case "float[]": {
                return float[].class;
            }
            case "long[]": {
                return long[].class;
            }
            case "double[]": {
                return double[].class;
            }
            case "boolean[]": {
                return boolean[].class;
            }
            case "Byte[]": {
                return Byte[].class;
            }
            case "Character[]": {
                return Character[].class;
            }
            case "Short[]": {
                return Short[].class;
            }
            case "Integer[]": {
                return Integer[].class;
            }
            case "Float[]": {
                return Float[].class;
            }
            case "Long[]": {
                return Long[].class;
            }
            case "Double[]": {
                return Double[].class;
            }
            case "Boolean[]": {
                return Boolean[].class;
            }
            case "String[]": {
                return String[].class;
            }
        }
        return null;
    }

    static Object createArrayInSize(Class<?> componentClass, int size) {
        if (Byte.TYPE.equals(componentClass)) {
            return new byte[size];
        }
        if (Character.TYPE.equals(componentClass)) {
            return new char[size];
        }
        if (Short.TYPE.equals(componentClass)) {
            return new short[size];
        }
        if (Integer.TYPE.equals(componentClass)) {
            return new int[size];
        }
        if (Float.TYPE.equals(componentClass)) {
            return new float[size];
        }
        if (Long.TYPE.equals(componentClass)) {
            return new long[size];
        }
        if (Double.TYPE.equals(componentClass)) {
            return new double[size];
        }
        if (Boolean.TYPE.equals(componentClass)) {
            return new boolean[size];
        }
        if (Character.class.equals(componentClass)) {
            return new Character[size];
        }
        if (Byte.class.equals(componentClass)) {
            return new Byte[size];
        }
        if (Short.class.equals(componentClass)) {
            return new Short[size];
        }
        if (Integer.class.equals(componentClass)) {
            return new Integer[size];
        }
        if (Float.class.equals(componentClass)) {
            return new Float[size];
        }
        if (Long.class.equals(componentClass)) {
            return new Long[size];
        }
        if (Double.class.equals(componentClass)) {
            return new Double[size];
        }
        if (Boolean.class.equals(componentClass)) {
            return new Boolean[size];
        }
        if (String.class.equals(componentClass)) {
            return new String[size];
        }
        return null;
    }
}

