/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.SharedPreferences;
import android.content.res.Resources;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;

public abstract class SharedPreference<Type> {
    String mKey = "";
    Type mDefaultValue;
    Type mValue;
    private int mKeyRes = -1;
    private boolean mAlreadyParsed;

    protected SharedPreference(@NonNull String key, @Nullable Type defValue) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Preference key cannot be empty.");
        }
        this.mKey = key;
        this.mValue = defValue;
        this.mDefaultValue = this.mValue;
    }

    protected SharedPreference(@StringRes int keyResId, @Nullable Type defaultValue) {
        if (keyResId <= 0) {
            throw new IllegalArgumentException("Resource id(" + keyResId + ") for preference key is not valid.");
        }
        this.mKeyRes = keyResId;
        this.mDefaultValue = defaultValue;
    }

    @NonNull
    public final String getKey() {
        return this.mKey;
    }

    @StringRes
    public final int getKeyRes() {
        return this.mKeyRes;
    }

    public SharedPreference<Type> attachKey(@NonNull Resources resources) {
        if (this.mKeyRes != -1) {
            this.mKey = resources.getString(this.mKeyRes);
            if (TextUtils.isEmpty((CharSequence)this.mKey)) {
                throw new IllegalArgumentException("Preference key cannot be empty.");
            }
        }
        return this;
    }

    @Nullable
    public final Type getDefaultValue() {
        return this.mDefaultValue;
    }

    public SharedPreference<Type> retrieve(@NonNull SharedPreferences preferences) {
        this.mValue = this.getFromPreferences(preferences);
        return this;
    }

    final Type getFromPreferences(SharedPreferences preferences) {
        this.ensureValidKeyOrThrow();
        if (!this.mAlreadyParsed) {
            this.mValue = this.onGetFromPreferences(preferences);
            this.mAlreadyParsed = true;
        }
        return this.mValue;
    }

    private void ensureValidKeyOrThrow() {
        if (TextUtils.isEmpty((CharSequence)this.mKey)) {
            String preferenceType = this.getClass().getSimpleName();
            throw new IllegalStateException("Key for preference(" + preferenceType + ") is not properly initialized. " + "Didn't you forget to set it up via SharedPreference.attachKey(Resources)?");
        }
    }

    @Nullable
    protected abstract Type onGetFromPreferences(@NonNull SharedPreferences var1);

    @CheckResult
    public boolean save(@NonNull SharedPreferences preferences) {
        return this.putIntoPreferences(preferences);
    }

    final boolean putIntoPreferences(SharedPreferences preferences) {
        this.ensureValidKeyOrThrow();
        this.mAlreadyParsed = this.onPutIntoPreferences(preferences);
        return this.mAlreadyParsed;
    }

    @CheckResult
    protected abstract boolean onPutIntoPreferences(@NonNull SharedPreferences var1);

    @NonNull
    public SharedPreferences.OnSharedPreferenceChangeListener createOnChangeListener(final @NonNull PreferenceChangeCallback<Type> callback) {
        return new SharedPreferences.OnSharedPreferenceChangeListener(){

            public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
                if (SharedPreference.this.mKey.equals(key)) {
                    SharedPreference.this.retrieve(sharedPreferences);
                    callback.onPreferenceChanged(SharedPreference.this);
                }
            }
        };
    }

    @Nullable
    public final Type getValue() {
        return this.mValue;
    }

    public SharedPreference<Type> updateValue(@Nullable Type newValue) {
        if (this.mValue == null || !this.mValue.equals(newValue)) {
            this.mValue = newValue;
            this.mAlreadyParsed = true;
        }
        return this;
    }

    final void clear() {
        this.mValue = null;
        this.mAlreadyParsed = false;
    }

    public static interface PreferenceChangeCallback<PreferenceType> {
        public void onPreferenceChanged(@NonNull SharedPreference<PreferenceType> var1);
    }
}

