/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.preference.SharedPreference;

public abstract class PreferencesManager {
    private static final String TAG = "PreferencesManager";
    public static final int MODE_PRIVATE = 0;
    public static final int MODE_MULTI_PROCESS = 4;
    public static final int MODE_ENABLE_WRITE_AHEAD_LOGGING = 8;
    public static final int MODE_APPEND = 32768;
    private static final int GENERIC = 0;
    private static final int INTEGER = 1;
    private static final int FLOAT = 2;
    private static final int LONG = 3;
    private static final int BOOLEAN = 4;
    private static final int STRING = 5;
    protected final Context mContext;
    private String mSharedPreferencesName = "";
    private int mMode = 0;
    private boolean mCachingEnabled = false;

    protected PreferencesManager(@NonNull Context context) {
        this(context, PreferencesManager.defaultSharedPreferencesName(context));
    }

    protected PreferencesManager(@NonNull Context context, @NonNull String preferencesName) {
        this(context, preferencesName, 0);
    }

    protected PreferencesManager(@NonNull Context context, @NonNull String preferencesName, int mode) {
        this.mContext = context.getApplicationContext();
        this.setSharedPreferencesName(preferencesName);
        this.setMode(mode);
    }

    @NonNull
    public static String defaultSharedPreferencesName(@NonNull Context context) {
        return context.getPackageName() + "_preferences";
    }

    protected final int getMode() {
        return this.mMode;
    }

    protected final void setMode(int mode) {
        switch (mode) {
            case 0: 
            case 4: 
            case 8: 
            case 32768: {
                this.mMode = mode;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Invalid file creation mode(" + mode + ") for shared preferences."));
            }
        }
    }

    protected final void setSharedPreferencesName(@Nullable String name) {
        this.mSharedPreferencesName = name;
    }

    @Nullable
    protected final String getSharedPreferencesName() {
        return this.mSharedPreferencesName;
    }

    @NonNull
    public SharedPreferences getSharedPreferences() {
        return this.preferences(this.mContext);
    }

    private SharedPreferences preferences(Context context) {
        if (!TextUtils.isEmpty((CharSequence)this.mSharedPreferencesName)) {
            return context.getSharedPreferences(this.mSharedPreferencesName, this.mMode);
        }
        return PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    protected final void setCachingEnabled(boolean enabled) {
        this.mCachingEnabled = enabled;
    }

    protected final boolean isCachingEnabled() {
        return this.mCachingEnabled;
    }

    @NonNull
    protected final String key(@StringRes int resId) {
        return this.mContext.getString(resId);
    }

    public void registerOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.preferences(this.mContext).registerOnSharedPreferenceChangeListener(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(@NonNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.preferences(this.mContext).unregisterOnSharedPreferenceChangeListener(listener);
    }

    public final boolean putInt(@NonNull String key, int value) {
        return this.putElement(key, value, 1, this.mContext);
    }

    public final int getInt(@NonNull String key, int defValue) {
        return (Integer)this.getElement(key, defValue, 1, this.mContext);
    }

    public final boolean putFloat(@NonNull String key, float value) {
        return this.putElement(key, Float.valueOf(value), 2, this.mContext);
    }

    public final float getFloat(@NonNull String key, float defValue) {
        return ((Float)this.getElement(key, Float.valueOf(defValue), 2, this.mContext)).floatValue();
    }

    public final boolean putLong(@NonNull String key, long value) {
        return this.putElement(key, value, 3, this.mContext);
    }

    public final long getLong(@NonNull String key, long defValue) {
        return (Long)this.getElement(key, defValue, 3, this.mContext);
    }

    public final boolean putBoolean(@NonNull String key, boolean value) {
        return this.putElement(key, value, 4, this.mContext);
    }

    public final boolean getBoolean(@NonNull String key, boolean defValue) {
        return (Boolean)this.getElement(key, defValue, 4, this.mContext);
    }

    public final boolean putString(@NonNull String key, @Nullable String value) {
        return this.putElement(key, value, 5, this.mContext);
    }

    public final String getString(@NonNull String key, @Nullable String defValue) {
        return (String)this.getElement(key, defValue, 5, this.mContext);
    }

    public final boolean contains(@NonNull String key) {
        return this.preferences(this.mContext).contains(key);
    }

    public final boolean remove(@NonNull String key) {
        SharedPreferences prefs = this.preferences(this.mContext);
        SharedPreferences.Editor editor = prefs.edit();
        return editor.remove(key).commit();
    }

    public final <Type> boolean putPreference(@NonNull SharedPreference<Type> preference, @Nullable Type value) {
        preference.attachKey(this.mContext.getResources()).updateValue(value);
        boolean succeed = preference.putIntoPreferences(this.preferences(this.mContext));
        if (!this.mCachingEnabled) {
            preference.clear();
        }
        return succeed;
    }

    public final <Type> Type getPreference(@NonNull SharedPreference<Type> preference) {
        preference.attachKey(this.mContext.getResources());
        Type value = preference.getFromPreferences(this.preferences(this.mContext));
        if (!this.mCachingEnabled) {
            preference.clear();
        }
        return value;
    }

    public final boolean containsPreference(@NonNull SharedPreference preference) {
        preference.attachKey(this.mContext.getResources());
        return this.contains(preference.getKey());
    }

    public final boolean removePreference(@NonNull SharedPreference preference) {
        preference.attachKey(this.mContext.getResources());
        return this.remove(preference.getKey());
    }

    private boolean putElement(String key, Object value, int type, Context context) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Empty preference keys are not allowed!");
        }
        SharedPreferences prefs = this.preferences(context);
        SharedPreferences.Editor editor = prefs.edit();
        switch (type) {
            case 0: {
                if (value instanceof Integer) {
                    editor.putInt(key, ((Integer)value).intValue());
                    break;
                }
                if (value instanceof Float) {
                    editor.putFloat(key, ((Float)value).floatValue());
                    break;
                }
                if (value instanceof Long) {
                    editor.putLong(key, ((Long)value).longValue());
                    break;
                }
                if (value instanceof Boolean) {
                    editor.putBoolean(key, ((Boolean)value).booleanValue());
                    break;
                }
                if (value instanceof String) {
                    editor.putString(key, (String)value);
                    break;
                }
                String valueType = value.getClass().getSimpleName();
                throw new IllegalArgumentException("Failed to save value of(" + valueType + ") for preference with key(" + key + "). " + "Value is not of supported generic (primitive) type.");
            }
            case 4: {
                editor.putBoolean(key, ((Boolean)value).booleanValue());
                break;
            }
            case 1: {
                editor.putInt(key, ((Integer)value).intValue());
                break;
            }
            case 2: {
                editor.putFloat(key, ((Float)value).floatValue());
                break;
            }
            case 3: {
                editor.putLong(key, ((Long)value).longValue());
                break;
            }
            case 5: {
                editor.putString(key, (String)value);
            }
        }
        return editor.commit();
    }

    private Object getElement(String key, Object defValue, int type, Context context) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("Empty preference keys are not allowed!");
        }
        SharedPreferences prefs = this.preferences(context);
        switch (type) {
            case 0: {
                if (defValue == null) break;
                if (defValue instanceof Integer) {
                    return prefs.getInt(key, ((Integer)defValue).intValue());
                }
                if (defValue instanceof Float) {
                    return Float.valueOf(prefs.getFloat(key, ((Float)defValue).floatValue()));
                }
                if (defValue instanceof Long) {
                    return prefs.getLong(key, ((Long)defValue).longValue());
                }
                if (defValue instanceof Boolean) {
                    return prefs.getBoolean(key, ((Boolean)defValue).booleanValue());
                }
                if (defValue instanceof String) {
                    return prefs.getString(key, (String)defValue);
                }
                throw new IllegalArgumentException("Failed to retrieve value for preference with key(" + key + "). " + "Value is not of supported generic (primitive) type.");
            }
            case 4: {
                return prefs.getBoolean(key, ((Boolean)defValue).booleanValue());
            }
            case 1: {
                return prefs.getInt(key, ((Integer)defValue).intValue());
            }
            case 2: {
                return Float.valueOf(prefs.getFloat(key, ((Float)defValue).floatValue()));
            }
            case 3: {
                return prefs.getLong(key, ((Long)defValue).longValue());
            }
            case 5: {
                return prefs.getString(key, (String)defValue);
            }
        }
        return null;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

