/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.preference;

import android.content.SharedPreferences;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import java.util.Arrays;
import java.util.List;
import universum.studios.android.preference.ArrayPreference;
import universum.studios.android.preference.SharedPreference;

public final class ListPreference<T>
extends SharedPreference<List<T>> {
    private final Class<T> mComponentType;

    public ListPreference(@NonNull String key, @NonNull Class<T> componentType, @Nullable List<T> defValue) {
        super(key, defValue);
        this.mComponentType = componentType;
    }

    public ListPreference(@StringRes int keyResId, @NonNull Class<T> componentType, @Nullable List<T> defValue) {
        super(keyResId, defValue);
        this.mComponentType = componentType;
    }

    @Override
    @CheckResult
    protected boolean onPutIntoPreferences(@NonNull SharedPreferences preferences) {
        return ListPreference.putIntoPreferences(preferences, this.mKey, (List)this.mValue, this.mComponentType);
    }

    @CheckResult
    public static <T> boolean putIntoPreferences(@NonNull SharedPreferences preferences, @NonNull String key, @Nullable List<T> list, @NonNull Class<T> componentType) {
        SharedPreferences.Editor editor = preferences.edit();
        if (list != null) {
            Object[] array = (Object[])ArrayPreference.createArrayInSize(componentType, list.size());
            if (array != null) {
                list.toArray(array);
                return ArrayPreference.putIntoPreferences(preferences, key, array);
            }
            String componentName = componentType.getSimpleName();
            throw new IllegalArgumentException("Failed to put list of(" + componentName + ") into shared preferences. " + "Only lists of primitive types or theirs boxed representations including String are supported.");
        }
        editor.putString(key, null);
        return editor.commit();
    }

    @Override
    @Nullable
    protected List<T> onGetFromPreferences(@NonNull SharedPreferences preferences) {
        return ListPreference.getFromPreferences(preferences, this.mKey, (List)this.mDefaultValue);
    }

    public static <T> List<T> getFromPreferences(@NonNull SharedPreferences preferences, @NonNull String key, @Nullable List<T> defValue) {
        String value = preferences.getString(key, null);
        if (value != null) {
            try {
                Object[] array = (Object[])ArrayPreference.getFromPreferences(preferences, key, null);
                return Arrays.asList(array);
            }
            catch (ClassCastException e) {
                String arrayValue = ArrayPreference.extractArrayValueFromPreferenceValue(value);
                throw new ClassCastException("Cannot obtain a list for the key(" + key + ") from shared preferences. " + "Value(" + arrayValue + ") is not a list!");
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Failed to obtain list for the key(" + key + ") from shared preferences. " + "Only lists of primitive types or theirs boxed representations including String are supported.");
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Trying to obtain a list for the key(" + key + ") from shared preferences not saved by the Preferences library.");
            }
        }
        return defValue;
    }
}

