/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.pager.adapter;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.IdRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.util.LongSparseArray;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import java.util.Set;
import universum.studios.android.pager.adapter.PagerAdapterHelper;
import universum.studios.android.pager.adapter.PagerAdaptersLogging;

@SuppressLint(value={"LongLogTag"})
public abstract class FragmentStatePagerAdapter
extends PagerAdapter {
    private static final String TAG = "FragmentStatePagerAdapter";
    public static final int NO_POSITION = -1;
    @VisibleForTesting
    static final String STATE_FRAGMENT_STATES = FragmentStatePagerAdapter.class.getName() + ".STATE.FragmentStates";
    private final FragmentManager mFragmentManager;
    private boolean mMakeItemTags = true;
    private FragmentTransaction mPendingTransaction;
    private final LongSparseArray<Fragment> mFragments = new LongSparseArray(5);
    private final LongSparseArray<Fragment.SavedState> mSavedStates = new LongSparseArray(5);
    private Fragment mPrimaryItem;
    private int mPrimaryPosition = -1;

    public FragmentStatePagerAdapter(@NonNull FragmentManager fragmentManager) {
        this.mFragmentManager = fragmentManager;
    }

    public void startUpdate(@NonNull ViewGroup container) {
        if (container.getId() == -1) {
            throw new IllegalStateException("ViewPager with adapter " + (Object)((Object)this) + " requires a view id!");
        }
    }

    @NonNull
    @SuppressLint(value={"CommitTransaction"})
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        long itemId = this.getItemId(position);
        Fragment fragment = (Fragment)this.mFragments.get(itemId);
        if (fragment != null) {
            return fragment;
        }
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        fragment = this.getItem(position);
        Fragment.SavedState savedState = (Fragment.SavedState)this.mSavedStates.get(itemId);
        if (savedState != null) {
            fragment.setInitialSavedState(savedState);
        }
        fragment.setMenuVisibility(false);
        PagerAdapterHelper.setUserVisibleHint(fragment, false);
        this.mFragments.put(itemId, (Object)fragment);
        PagerAdaptersLogging.d(TAG, "Adding item(id: " + itemId + ", fragment: " + fragment + ").");
        int containerId = container.getId();
        this.mPendingTransaction.add(containerId, fragment, this.makeItemTag(containerId, itemId));
        return fragment;
    }

    protected final void setMakeItemTags(boolean makeItemTags) {
        this.mMakeItemTags = makeItemTags;
    }

    @Nullable
    protected String makeItemTag(@IdRes int containerId, long itemId) {
        return this.mMakeItemTags ? "android:pager:" + containerId + ":" + itemId : null;
    }

    public long getItemId(int position) {
        return position;
    }

    @NonNull
    public abstract Fragment getItem(int var1);

    public void setPrimaryItem(@NonNull ViewGroup container, int position, @Nullable Object object) {
        Fragment fragment = (Fragment)object;
        if (this.mPrimaryItem != fragment) {
            this.mPrimaryPosition = position;
            if (this.mPrimaryItem != null) {
                this.mPrimaryItem.setMenuVisibility(false);
                PagerAdapterHelper.setUserVisibleHint(this.mPrimaryItem, false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                PagerAdapterHelper.setUserVisibleHint(fragment, true);
            }
            this.mPrimaryItem = fragment;
        }
    }

    @Nullable
    public Fragment getPrimaryFragment() {
        return this.mPrimaryItem;
    }

    @IntRange(from=-1L)
    public int getPrimaryPosition() {
        return this.mPrimaryPosition;
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return ((Fragment)object).getView() == view;
    }

    @SuppressLint(value={"CommitTransaction"})
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        Fragment fragment;
        int itemIndex;
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        if (position == this.mPrimaryPosition) {
            this.mPrimaryPosition = -1;
            this.mPrimaryItem = null;
        }
        if ((itemIndex = this.mFragments.indexOfValue((Object)(fragment = (Fragment)object))) != -1) {
            long itemId = this.mFragments.keyAt(itemIndex);
            PagerAdaptersLogging.d(TAG, "Removing item(id: " + itemId + ", fragment: " + fragment + ", view: " + fragment.getView() + ").");
            if (fragment.isAdded()) {
                this.mSavedStates.put(itemId, (Object)this.mFragmentManager.saveFragmentInstanceState(fragment));
            } else {
                this.mSavedStates.remove(itemId);
            }
            this.mFragments.remove(itemId);
        }
        this.mPendingTransaction.remove(fragment);
    }

    public void finishUpdate(@NonNull ViewGroup container) {
        if (this.mPendingTransaction != null) {
            PagerAdapterHelper.finishUpdate(this.mFragmentManager, this.mPendingTransaction);
            this.mPendingTransaction = null;
        }
    }

    public Parcelable saveState() {
        Bundle state = null;
        int statesCount = this.mSavedStates.size();
        if (statesCount > 0) {
            state = new Bundle();
            long[] savedStateIds = new long[statesCount];
            for (int i = 0; i < statesCount; ++i) {
                long itemId;
                savedStateIds[i] = itemId = this.mSavedStates.keyAt(i);
                state.putParcelable("android:pager:fragment_state:" + itemId, (Parcelable)this.mSavedStates.valueAt(i));
            }
            state.putLongArray(STATE_FRAGMENT_STATES, savedStateIds);
        }
        for (int i = 0; i < this.mFragments.size(); ++i) {
            long itemId = this.mFragments.keyAt(i);
            Fragment fragment = (Fragment)this.mFragments.get(itemId);
            if (!fragment.isAdded()) continue;
            if (state == null) {
                state = new Bundle();
            }
            this.mFragmentManager.putFragment(state, "android:pager:fragment:" + itemId, fragment);
        }
        return state;
    }

    public void restoreState(@Nullable Parcelable state, @NonNull ClassLoader loader) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            bundle.setClassLoader(loader);
            long[] savedStateIds = bundle.getLongArray(STATE_FRAGMENT_STATES);
            this.mSavedStates.clear();
            this.mFragments.clear();
            if (savedStateIds != null) {
                for (int i = 0; i < savedStateIds.length; ++i) {
                    long itemId = savedStateIds[i];
                    this.mSavedStates.put(itemId, (Object)bundle.getParcelable("android:pager:fragment_state:" + itemId));
                }
            }
            Set keys = bundle.keySet();
            for (String key : keys) {
                if (!key.startsWith("android:pager:fragment:")) continue;
                Fragment fragment = this.mFragmentManager.getFragment(bundle, key);
                if (fragment == null) {
                    PagerAdaptersLogging.w(TAG, "Fragment not found for the key " + key + " when restoring adapter's state.");
                    continue;
                }
                fragment.setMenuVisibility(false);
                this.mFragments.put(Long.parseLong(key.split(":")[3]), (Object)fragment);
            }
        }
    }
}

