/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.pager.adapter;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.support.annotation.IdRes;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import universum.studios.android.pager.adapter.PagerAdapterHelper;
import universum.studios.android.pager.adapter.PagerAdaptersLogging;

public abstract class FragmentPagerAdapter
extends PagerAdapter {
    private static final String TAG = "FragmentPagerAdapter";
    public static final int NO_POSITION = -1;
    private final FragmentManager mFragmentManager;
    private boolean mMakeItemTags = true;
    private FragmentTransaction mPendingTransaction;
    private Fragment mPrimaryItem;
    private int mPrimaryPosition = -1;

    public FragmentPagerAdapter(@NonNull FragmentManager fragmentManager) {
        this.mFragmentManager = fragmentManager;
    }

    public void startUpdate(@NonNull ViewGroup container) {
        if (container.getId() == -1) {
            throw new IllegalStateException("ViewPager with adapter " + (Object)((Object)this) + " requires a view id!");
        }
    }

    @NonNull
    @SuppressLint(value={"CommitTransaction"})
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        long itemId;
        int containerId;
        String tag;
        Fragment fragment;
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        if ((fragment = this.mFragmentManager.findFragmentByTag(tag = this.makeItemTag(containerId = container.getId(), itemId = this.getItemId(position)))) == null) {
            fragment = this.getItem(position);
            PagerAdaptersLogging.d(TAG, "Adding item(id: " + itemId + ", fragment: " + fragment + ").");
            this.mPendingTransaction.add(containerId, fragment, tag);
        } else {
            PagerAdaptersLogging.d(TAG, "Attaching item(id: " + itemId + ", fragment: " + fragment + ").");
            this.mPendingTransaction.attach(fragment);
        }
        if (!fragment.equals((Object)this.mPrimaryItem)) {
            fragment.setMenuVisibility(false);
            PagerAdapterHelper.setUserVisibleHint(fragment, false);
        }
        return fragment;
    }

    protected final void setMakeItemTags(boolean makeItemTags) {
        this.mMakeItemTags = makeItemTags;
    }

    @Nullable
    protected String makeItemTag(@IdRes int containerId, long itemId) {
        return this.mMakeItemTags ? "android:pager:" + containerId + ":" + itemId : null;
    }

    public long getItemId(int position) {
        return position;
    }

    @NonNull
    public abstract Fragment getItem(int var1);

    public void setPrimaryItem(@NonNull ViewGroup container, int position, @Nullable Object object) {
        Fragment fragment = (Fragment)object;
        if (this.mPrimaryItem != fragment) {
            this.mPrimaryPosition = position;
            if (this.mPrimaryItem != null) {
                this.mPrimaryItem.setMenuVisibility(false);
                PagerAdapterHelper.setUserVisibleHint(this.mPrimaryItem, false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                PagerAdapterHelper.setUserVisibleHint(fragment, true);
            }
            this.mPrimaryItem = fragment;
        }
    }

    @Nullable
    public Fragment getPrimaryFragment() {
        return this.mPrimaryItem;
    }

    @IntRange(from=-1L)
    public int getPrimaryPosition() {
        return this.mPrimaryPosition;
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return ((Fragment)object).getView() == view;
    }

    @SuppressLint(value={"CommitTransaction"})
    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        if (position == this.mPrimaryPosition) {
            this.mPrimaryPosition = -1;
            this.mPrimaryItem = null;
        }
        PagerAdaptersLogging.d(TAG, "Detaching item(id: " + this.getItemId(position) + ", fragment: " + object + ", view: " + ((Fragment)object).getView() + ").");
        this.mPendingTransaction.detach((Fragment)object);
    }

    public void finishUpdate(@NonNull ViewGroup container) {
        if (this.mPendingTransaction != null) {
            PagerAdapterHelper.finishUpdate(this.mFragmentManager, this.mPendingTransaction);
            this.mPendingTransaction = null;
        }
    }
}

