/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.pager.adapter;

import android.annotation.SuppressLint;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import universum.studios.android.pager.adapter.PagerAdaptersConfig;

public abstract class FragmentPagerAdapter
extends PagerAdapter {
    private static final String TAG = "FragmentPagerAdapter";
    private final FragmentManager mFragmentManager;
    private boolean mMakeItemTags = true;
    private FragmentTransaction mPendingTransaction = null;
    Fragment mPrimaryItem = null;

    public FragmentPagerAdapter(@NonNull FragmentManager fragmentManager) {
        this.mFragmentManager = fragmentManager;
    }

    static void setUserVisibleHint(@NonNull Fragment fragment, boolean visible) {
        if (Build.VERSION.SDK_INT >= 15) {
            fragment.setUserVisibleHint(visible);
        }
    }

    public void startUpdate(ViewGroup container) {
        if (container.getId() == -1) {
            throw new IllegalStateException("ViewPager with adapter " + (Object)((Object)this) + " requires a view id!");
        }
    }

    @SuppressLint(value={"CommitTransaction"})
    public Object instantiateItem(ViewGroup container, int position) {
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        long itemId = this.getItemId(position);
        String tag = this.makeItemTag(container.getId(), itemId);
        Fragment fragment = this.mFragmentManager.findFragmentByTag(tag);
        if (fragment != null) {
            if (PagerAdaptersConfig.DEBUG_LOG_ENABLED) {
                Log.v((String)TAG, (String)("Attaching item(id: " + itemId + ", fragment: " + fragment + ")."));
            }
            this.mPendingTransaction.attach(fragment);
        } else {
            fragment = this.getItem(position);
            if (PagerAdaptersConfig.DEBUG_LOG_ENABLED) {
                Log.v((String)TAG, (String)("Adding item(id: " + itemId + ", fragment: " + fragment + ")."));
            }
            int containerId = container.getId();
            this.mPendingTransaction.add(containerId, fragment, this.makeItemTag(containerId, itemId));
        }
        if (fragment != this.mPrimaryItem) {
            fragment.setMenuVisibility(false);
            FragmentPagerAdapter.setUserVisibleHint(fragment, false);
        }
        return fragment;
    }

    protected final void setMakeItemTags(boolean makeItemTags) {
        this.mMakeItemTags = makeItemTags;
    }

    @Nullable
    protected String makeItemTag(@IdRes int containerId, long itemId) {
        return this.mMakeItemTags ? "android:pager:" + containerId + ":" + itemId : null;
    }

    public long getItemId(int position) {
        return position;
    }

    @NonNull
    public abstract Fragment getItem(int var1);

    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (this.mPrimaryItem != fragment) {
            if (this.mPrimaryItem != null) {
                this.mPrimaryItem.setMenuVisibility(false);
                FragmentPagerAdapter.setUserVisibleHint(this.mPrimaryItem, false);
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                FragmentPagerAdapter.setUserVisibleHint(fragment, true);
            }
            this.mPrimaryItem = fragment;
        }
    }

    public boolean isViewFromObject(View view, Object object) {
        return ((Fragment)object).getView() == view;
    }

    @SuppressLint(value={"CommitTransaction"})
    public void destroyItem(ViewGroup container, int position, Object object) {
        if (this.mPendingTransaction == null) {
            this.mPendingTransaction = this.mFragmentManager.beginTransaction();
        }
        if (PagerAdaptersConfig.DEBUG_LOG_ENABLED) {
            Log.v((String)TAG, (String)("Detaching item(id: " + this.getItemId(position) + ", fragment: " + object + ", view: " + ((Fragment)object).getView() + ")."));
        }
        this.mPendingTransaction.detach((Fragment)object);
    }

    public void finishUpdate(ViewGroup container) {
        if (this.mPendingTransaction != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.mPendingTransaction.commitNowAllowingStateLoss();
            } else {
                this.mPendingTransaction.commitAllowingStateLoss();
            }
            this.mPendingTransaction = null;
        }
    }
}

