/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import universum.studios.android.officium.OfficiumLogging;
import universum.studios.android.officium.sync.OnSyncTaskStateChangeListener;
import universum.studios.android.officium.sync.SyncTask;

public abstract class BaseSyncManager
implements OnSyncTaskStateChangeListener {
    private static final String TAG = "BaseSyncManager";
    public static final String PERMISSION_WRITE_SYNC_SETTINGS = "android.permission.WRITE_SYNC_SETTINGS";
    public static final String PERMISSION_READ_SYNC_SETTINGS = "android.permission.READ_SYNC_SETTINGS";
    public static final String PERMISSION_READ_SYNC_STATS = "android.permission.READ_SYNC_STATS";
    private final Context context;
    private final String authority;

    public BaseSyncManager(@NonNull Context context, @NonNull String authority) {
        this.context = context;
        this.authority = authority;
    }

    @NonNull
    public final Context getContext() {
        return this.context;
    }

    @NonNull
    public final String getAuthority() {
        return this.authority;
    }

    @RequiresPermission(value="android.permission.WRITE_SYNC_SETTINGS")
    public void startAutomaticSync() {
        this.setAutomaticSyncEnabled(true);
    }

    @RequiresPermission(value="android.permission.READ_SYNC_SETTINGS")
    public boolean isAutomaticSyncRunning() {
        Account account = this.pickAccountForSync();
        return account != null && ContentResolver.getSyncAutomatically((Account)account, (String)this.authority);
    }

    @RequiresPermission(value="android.permission.WRITE_SYNC_SETTINGS")
    public void stopAutomaticSync() {
        this.setAutomaticSyncEnabled(false);
    }

    private void setAutomaticSyncEnabled(boolean enabled) {
        Account account = this.pickAccountForSync();
        if (account != null) {
            ContentResolver.setSyncAutomatically((Account)account, (String)this.authority, (boolean)enabled);
        }
    }

    public void requestGlobalSync() {
        this.requestSync(new SyncTask.Builder(0).build());
    }

    public void requestSync(@NonNull SyncTask syncTask) {
        Account account = this.pickAccountForSync();
        if (account == null) {
            OfficiumLogging.w(TAG, "Cannot perform synchronization for task(" + syncTask + "). No account picked for synchronization.");
        } else if (this.shouldRequestSync(syncTask, account)) {
            syncTask.setState(1);
            this.onSyncTaskStateChanged(syncTask, account);
            Bundle extras = syncTask.intoExtras(new Bundle());
            extras.putBoolean("force", true);
            extras.putBoolean("expedited", true);
            OfficiumLogging.i(TAG, "Requesting synchronization for task(" + syncTask + ").");
            ContentResolver.requestSync((Account)account, (String)this.authority, (Bundle)extras);
        }
    }

    protected boolean shouldRequestSync(@NonNull SyncTask syncTask, @NonNull Account account) {
        return true;
    }

    @Override
    @CallSuper
    public void onSyncTaskStateChanged(@NonNull SyncTask syncTask, @NonNull Account account) {
    }

    @RequiresPermission(value="android.permission.READ_SYNC_STATS")
    public boolean isSyncPending() {
        Account account = this.pickAccountForSync();
        return account != null && ContentResolver.isSyncPending((Account)account, (String)this.authority);
    }

    @RequiresPermission(value="android.permission.READ_SYNC_STATS")
    public boolean isSyncActive() {
        Account account = this.pickAccountForSync();
        return account != null && ContentResolver.isSyncActive((Account)account, (String)this.authority);
    }

    public void cancelSync() {
        Account account = this.pickAccountForSync();
        if (account != null) {
            this.onCancelSync(account);
        }
    }

    protected void onCancelSync(@NonNull Account account) {
        ContentResolver.cancelSync((Account)account, (String)this.authority);
    }

    @Nullable
    protected abstract Account pickAccountForSync();
}

