/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service.auth;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import universum.studios.android.officium.service.auth.AuthTokenProvider;

public final class AuthRequestInterceptor
implements Interceptor {
    public static final String HEADER_NAME = "Authorization";
    public static final AuthRequestInterceptor UNAUTHORIZED = AuthRequestInterceptor.create(AuthTokenProvider.UNAUTHORIZED);
    private final AuthTokenProvider tokenProvider;

    private AuthRequestInterceptor(@NonNull AuthTokenProvider tokenProvider) {
        this.tokenProvider = tokenProvider;
    }

    @NonNull
    public static AuthRequestInterceptor create(final @Nullable String token) {
        return AuthRequestInterceptor.create(new AuthTokenProvider(){

            @Override
            @Nullable
            public String peekToken() {
                return token;
            }
        });
    }

    @NonNull
    public static AuthRequestInterceptor create(@NonNull AuthTokenProvider tokenProvider) {
        return new AuthRequestInterceptor(tokenProvider);
    }

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        String authToken = this.tokenProvider.peekToken();
        Request request = chain.request();
        return authToken == null || authToken.length() == 0 ? chain.proceed(request) : chain.proceed(request.newBuilder().header(HEADER_NAME, "Bearer " + authToken).build());
    }
}

