/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service;

import androidx.annotation.NonNull;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import universum.studios.android.officium.service.BaseServiceObject;
import universum.studios.android.officium.service.ServiceError;
import universum.studios.android.officium.service.ServiceObject;

public abstract class ServiceCallback<R>
extends BaseServiceObject
implements Callback<R> {
    public void onResponse(@NonNull Call<R> call, @NonNull Response<R> response) {
        if (response.isSuccessful()) {
            Object responseBody = response.body();
            if (responseBody instanceof ServiceObject) {
                ServiceCallback.associateWith((ServiceObject)responseBody, this.serviceId, this.requestId);
            }
            assert (responseBody != null);
            this.onDispatchResponse(responseBody);
        } else {
            ResponseBody errorBody = response.errorBody();
            assert (errorBody != null);
            ServiceError error = new ServiceError(response.code(), errorBody);
            ServiceCallback.associateWith(error, this.serviceId, this.requestId);
            this.onDispatchError(error);
        }
    }

    protected abstract void onDispatchResponse(@NonNull R var1);

    public void onFailure(@NonNull Call<R> call, @NonNull Throwable failure) {
        ServiceError error = new ServiceError(failure);
        ServiceCallback.associateWith(error, this.serviceId, this.requestId);
        this.onDispatchError(error);
    }

    protected abstract void onDispatchError(@NonNull ServiceError var1);
}

