/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import java.io.IOException;
import okhttp3.Request;
import okio.Timeout;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import universum.studios.android.officium.service.ServiceCallback;

public class ServiceCall<T>
implements Call<T> {
    @VisibleForTesting
    final Call<T> call;
    @VisibleForTesting
    Integer serviceId;

    public ServiceCall(@NonNull Call<T> call) {
        this.call = call;
    }

    public ServiceCall<T> withServiceId(int serviceId) {
        if (this.serviceId == null) {
            this.serviceId = serviceId;
            return this;
        }
        throw new UnsupportedOperationException("Service id is already specified!");
    }

    @NonNull
    public Response<T> execute() throws IOException {
        return this.call.execute();
    }

    @NonNull
    public String enqueue(@NonNull ServiceCallback<T> callback) {
        String requestId = this.nextRequestId();
        ServiceCallback.associateWith(callback, this.serviceId, requestId);
        this.enqueue((Callback<T>)callback);
        return requestId;
    }

    @NonNull
    protected String nextRequestId() {
        return Long.toString(System.currentTimeMillis());
    }

    public void enqueue(@NonNull Callback<T> callback) {
        this.call.enqueue(callback);
    }

    public boolean isExecuted() {
        return this.call.isExecuted();
    }

    public void cancel() {
        this.call.cancel();
    }

    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @NonNull
    public Request request() {
        return this.call.request();
    }

    @NonNull
    public Timeout timeout() {
        return this.call.timeout();
    }

    @NonNull
    public ServiceCall<T> clone() {
        ServiceCall<T> serviceCall = new ServiceCall<T>(this.call.clone());
        serviceCall.serviceId = this.serviceId;
        return serviceCall;
    }
}

