/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.account;

import android.os.Bundle;
import androidx.annotation.NonNull;
import universum.studios.android.officium.account.AccountError;
import universum.studios.android.officium.account.AccountResult;

public final class AccountResults {
    private AccountResults() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static AccountResult empty() {
        return ResultImpl.EMPTY;
    }

    @NonNull
    public static AccountResult createSuccess() {
        return AccountResults.createSuccess(Bundle.EMPTY);
    }

    @NonNull
    public static AccountResult createSuccess(@NonNull Bundle value) {
        return new ResultImpl(value, AccountError.NONE);
    }

    @NonNull
    public static AccountResult createFailure(@NonNull AccountError error) {
        return new ResultImpl(null, error);
    }

    private static class ResultImpl
    implements AccountResult {
        private static final AccountResult EMPTY = new ResultImpl(Bundle.EMPTY, AccountError.NONE);
        private final Bundle value;
        private final AccountError error;

        ResultImpl(Bundle value, AccountError error) {
            this.value = value;
            this.error = error;
        }

        @Override
        public boolean isSuccess() {
            return !this.isFailure();
        }

        @Override
        @NonNull
        public Bundle getValue() {
            return this.value;
        }

        @Override
        public boolean isFailure() {
            return this.error != AccountError.NONE;
        }

        @Override
        @NonNull
        public AccountError getError() {
            return this.error;
        }

        @NonNull
        public String toString() {
            StringBuilder builder = new StringBuilder(64);
            builder.append(AccountResult.class.getSimpleName());
            builder.append("(isSuccess: ");
            builder.append(this.isSuccess());
            builder.append(", value: ");
            builder.append(this.value);
            builder.append(", isFailure: ");
            builder.append(this.isFailure());
            builder.append(", error: ");
            builder.append(this.error);
            return builder.append(")").toString();
        }
    }
}

