/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.account;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseAccount {
    public static final String TOKEN_TYPE_O_AUTH = "oAuth";
    protected static final String[] AUTH_TOKEN_TYPES = new String[]{"oAuth"};
    @NonNull
    private final String name;
    @Nullable
    private String password;
    @Nullable
    private Map<String, String> authTokens;
    @Nullable
    private Bundle dataBundle;

    protected BaseAccount(@NonNull String name) {
        this(name, null);
    }

    protected BaseAccount(@NonNull String name, @Nullable String password) {
        this.name = name;
        this.password = password;
    }

    @NonNull
    public final String getName() {
        return this.name;
    }

    public final void setPassword(@Nullable String password) {
        this.password = password;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    @Nullable
    protected String[] getAuthTokenTypes() {
        return AUTH_TOKEN_TYPES;
    }

    public void setOAuthToken(@Nullable String token) {
        if (token == null) {
            this.removeAuthToken(TOKEN_TYPE_O_AUTH);
        } else {
            this.putAuthToken(TOKEN_TYPE_O_AUTH, token);
        }
    }

    @Nullable
    public String getOAuthToken() {
        return this.getAuthToken(TOKEN_TYPE_O_AUTH);
    }

    protected void putAuthToken(@NonNull String tokenType, @NonNull String token) {
        if (this.authTokens == null) {
            this.authTokens = new HashMap<String, String>(1);
        }
        this.authTokens.put(tokenType, token);
    }

    protected boolean hasAuthToken(@Nullable String tokenType) {
        return this.authTokens != null && this.authTokens.containsKey(tokenType);
    }

    protected void removeAuthToken(@NonNull String tokenType) {
        if (this.authTokens != null) {
            this.authTokens.remove(tokenType);
        }
    }

    @Nullable
    protected String getAuthToken(@Nullable String tokenType) {
        return this.authTokens == null ? null : this.authTokens.get(tokenType);
    }

    @Nullable
    protected Map<String, String> getAuthTokens() {
        return this.authTokens;
    }

    protected void putData(@NonNull String key, @Nullable String data) {
        if (this.dataBundle == null) {
            this.dataBundle = new Bundle();
        }
        this.dataBundle.putString(key, data);
    }

    protected boolean hasData(@NonNull String key) {
        return this.dataBundle != null && this.dataBundle.containsKey(key);
    }

    @Nullable
    protected String getData(@NonNull String key) {
        return this.dataBundle == null ? null : this.dataBundle.getString(key);
    }

    protected void removeData(@NonNull String key) {
        if (this.dataBundle != null) {
            this.dataBundle.remove(key);
        }
    }

    protected void setDataBundle(@Nullable Bundle dataBundle) {
        this.dataBundle = dataBundle;
    }

    @Nullable
    protected Bundle getDataBundle() {
        return this.dataBundle;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof BaseAccount)) {
            return false;
        }
        BaseAccount account = (BaseAccount)other;
        return this.name.equals(account.name);
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder(32);
        builder.append(this.getClass().getSimpleName());
        builder.append("(name: ");
        builder.append(this.name);
        return builder.append(")").toString();
    }
}

