/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import universum.studios.android.officium.sync.SyncExtras;

public class SyncTask<R extends Request>
implements Cloneable {
    public static final int IDLE = 0;
    public static final int PENDING = 1;
    public static final int RUNNING = 2;
    public static final int FINISHED = 3;
    public static final int FAILED = 4;
    public static final int CANCELED = 5;
    public static final int DEFAULT_ID = 0;
    public static final SyncTask<EmptyRequest> EMPTY = new SyncTask();
    private static final Gson GSON = new Gson();
    private final int id;
    private R request;
    private final String requestBody;
    private int state = 0;

    private SyncTask() {
        this.id = -1;
        this.requestBody = null;
    }

    protected SyncTask(@NonNull Builder<R> builder) {
        this.id = ((Builder)builder).id;
        this.request = ((Builder)builder).request;
        this.requestBody = this.request == null ? null : GSON.toJson(this.request);
    }

    protected SyncTask(@NonNull Bundle extras) {
        this.id = extras.getInt(SyncExtras.EXTRA_TASK_ID, 0);
        this.requestBody = extras.getString(SyncExtras.EXTRA_TASK_REQUEST_BODY);
        this.state = extras.getInt(SyncExtras.EXTRA_TASK_STATE, this.state);
    }

    protected SyncTask(@NonNull SyncTask other) {
        this.id = other.id;
        this.requestBody = other.requestBody;
        this.state = other.state;
    }

    public SyncTask<R> clone() {
        SyncTask<R> clone = new SyncTask<R>(this);
        clone.state = 0;
        return clone;
    }

    public final int getId() {
        return this.id;
    }

    final void setState(int state) {
        this.state = state;
    }

    public final int getState() {
        return this.state;
    }

    @Nullable
    public final R getRequest(@NonNull Class<R> classOfRequest) {
        if (this.request == null) {
            this.request = TextUtils.isEmpty((CharSequence)this.requestBody) ? null : (Request)GSON.fromJson(this.requestBody, classOfRequest);
        }
        return this.request;
    }

    @Nullable
    public final String getRequestBody() {
        return this.requestBody;
    }

    @NonNull
    public Bundle intoExtras(@NonNull Bundle extras) {
        extras.putInt(SyncExtras.EXTRA_TASK_ID, this.id);
        extras.putString(SyncExtras.EXTRA_TASK_REQUEST_BODY, this.requestBody);
        extras.putInt(SyncExtras.EXTRA_TASK_STATE, this.state);
        return extras;
    }

    public int hashCode() {
        int hash = this.id;
        if (!TextUtils.isEmpty((CharSequence)this.requestBody)) {
            hash = 31 * hash + this.requestBody.hashCode();
        }
        return hash;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SyncTask)) {
            return false;
        }
        SyncTask task = (SyncTask)other;
        if (task.id != this.id) {
            return false;
        }
        return TextUtils.equals((CharSequence)this.requestBody, (CharSequence)task.requestBody);
    }

    @NonNull
    public String toString() {
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.getClass().getSimpleName());
        builder.append("(id: ");
        builder.append(this.id);
        builder.append(", state: ");
        builder.append(SyncTask.getStateName(this.state));
        builder.append(", request: ");
        builder.append(this.request == null ? this.requestBody : GSON.toJson(this.request));
        return builder.append(")").toString();
    }

    @VisibleForTesting
    static String getStateName(int state) {
        switch (state) {
            case 0: {
                return "IDLE";
            }
            case 1: {
                return "PENDING";
            }
            case 2: {
                return "RUNNING";
            }
            case 3: {
                return "FINISHED";
            }
            case 4: {
                return "FAILED";
            }
            case 5: {
                return "CANCELED";
            }
        }
        return "UNKNOWN";
    }

    public static class Builder<R extends Request> {
        private final int id;
        private R request;

        public Builder(int taskId) {
            this.id = taskId;
        }

        public Builder<R> request(@Nullable R request) {
            this.request = request;
            return this;
        }

        @NonNull
        public SyncTask<R> build() {
            return new SyncTask(this);
        }
    }

    public static final class EmptyRequest
    implements Request {
        private EmptyRequest() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Request {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

