/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.accounts.Account;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import universum.studios.android.officium.sync.SyncTask;

public final class SyncOperation {
    @NonNull
    public final Account account;
    @NonNull
    public final String authority;
    @NonNull
    public final SyncTask task;

    SyncOperation(Builder builder) {
        this.account = builder.account;
        this.authority = builder.authority;
        this.task = builder.task;
    }

    public static final class Builder {
        Account account;
        String authority;
        SyncTask task;

        public Builder account(@NonNull Account account) {
            this.account = account;
            return this;
        }

        public Builder authority(@NonNull String authority) {
            this.authority = authority;
            return this;
        }

        public Builder task(@NonNull SyncTask task) {
            this.task = task;
            return this;
        }

        @NonNull
        public SyncOperation build() {
            if (this.account == null) {
                throw new IllegalArgumentException("No account specified.");
            }
            if (TextUtils.isEmpty((CharSequence)this.authority)) {
                throw new IllegalArgumentException("No authority specified.");
            }
            if (this.task == null) {
                throw new IllegalArgumentException("No task specified.");
            }
            return new SyncOperation(this);
        }
    }
}

