/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.accounts.Account;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class SyncEvent {
    public static final int START = 1;
    public static final int PROGRESS = 2;
    public static final int FINISH = 3;
    public static final int FAILURE = 4;
    public final int taskId;
    public final int type;
    public final int progress;
    @Nullable
    public final Exception error;
    @Nullable
    public final Account account;
    @Nullable
    public final Bundle extras;

    SyncEvent(@NonNull Builder builder) {
        this.taskId = builder.taskId;
        this.type = builder.type;
        this.progress = builder.progress;
        this.error = builder.error;
        this.account = builder.account;
        this.extras = builder.extras;
    }

    public static final class Builder {
        final int taskId;
        int type = 1;
        int progress;
        Exception error;
        Account account;
        Bundle extras;

        public Builder(int taskId) {
            this.taskId = taskId;
        }

        public Builder type(int type) {
            this.type = type;
            return this;
        }

        public Builder account(@NonNull Account account) {
            this.account = account;
            return this;
        }

        public Builder progress(int progress) {
            this.progress = progress;
            return this;
        }

        public Builder error(@NonNull Exception error) {
            this.error = error;
            return this;
        }

        public Builder extras(@NonNull Bundle extras) {
            this.extras = extras;
            return this;
        }

        @NonNull
        public SyncEvent build() {
            return new SyncEvent(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

