/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.account;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import universum.studios.android.crypto.Crypto;
import universum.studios.android.crypto.Decrypto;
import universum.studios.android.crypto.Encrypto;
import universum.studios.android.crypto.util.CryptographyUtils;
import universum.studios.android.officium.account.AccountError;
import universum.studios.android.officium.account.AccountErrors;
import universum.studios.android.officium.account.AccountResult;
import universum.studios.android.officium.account.AccountResults;
import universum.studios.android.officium.account.BaseAccount;

public abstract class BaseAccountManager<A extends BaseAccount> {
    public static final String PERMISSION_GET_ACCOUNTS = "android.permission.GET_ACCOUNTS";
    public static final String PERMISSION_MANAGE_ACCOUNTS = "android.permission.MANAGE_ACCOUNTS";
    public static final String PERMISSION_AUTHENTICATE_ACCOUNTS = "android.permission.AUTHENTICATE_ACCOUNTS";
    public static final String ERROR_ACCOUNT_DOES_NOT_EXIST = "universum.studios.android.officium.account.AccountManager.ERROR.AccountDoesNotExist";
    public static final String ERROR_SYSTEM_OPERATION_FAILURE = "universum.studios.android.officium.account.AccountManager.ERROR.SystemOperationFailure";
    private final AccountManager systemManager;
    private final String accountType;
    private Encrypto keyEncrypto;
    private Crypto crypto;
    private final Handler mainHandler;
    private final List<AccountObserver<A>> observers = new ArrayList<AccountObserver<A>>(1);

    protected BaseAccountManager(@NonNull Context context, @NonNull String accountType) {
        this(AccountManager.get((Context)context), accountType);
    }

    @VisibleForTesting
    BaseAccountManager(AccountManager systemManager, String accountType) {
        this.systemManager = systemManager;
        this.accountType = accountType;
        this.mainHandler = new Handler(Looper.getMainLooper());
    }

    @NonNull
    public final String getAccountType() {
        return this.accountType;
    }

    @NonNull
    protected final AccountManager getSystemManager() {
        return this.systemManager;
    }

    public final void setKeyEncrypto(@Nullable Encrypto encrypto) {
        this.keyEncrypto = encrypto;
    }

    public final void setCrypto(@Nullable Crypto crypto) {
        this.crypto = crypto;
    }

    @VisibleForTesting
    Bundle encryptBundle(@Nullable Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return bundle;
        }
        Bundle encryptedBundle = new Bundle();
        Set keys = bundle.keySet();
        for (String key : keys) {
            encryptedBundle.putString(this.encryptKey(key), this.encrypt(bundle.getString(key)));
        }
        return encryptedBundle;
    }

    @Nullable
    protected final String encryptKey(@NonNull String key) {
        return this.keyEncrypto == null ? key : CryptographyUtils.encrypt((String)key, (Encrypto)this.keyEncrypto);
    }

    @Nullable
    protected final String encrypt(@Nullable String value) {
        return this.crypto == null || value == null ? value : CryptographyUtils.encrypt((String)value, (Encrypto)this.crypto);
    }

    @Nullable
    protected final String decrypt(@Nullable String value) {
        return this.crypto == null || value == null ? value : CryptographyUtils.decrypt((String)value, (Decrypto)this.crypto);
    }

    public final void registerObserver(@NonNull AccountObserver<A> observer) {
        if (!this.observers.contains(observer)) {
            this.observers.add(observer);
        }
    }

    final void notifyAccountAdded(A account) {
        if (!this.observers.isEmpty()) {
            this.mainHandler.post(new Runnable((BaseAccount)account){
                final /* synthetic */ BaseAccount val$account;
                {
                    this.val$account = baseAccount;
                }

                @Override
                public void run() {
                    for (AccountObserver observer : BaseAccountManager.this.observers) {
                        observer.onAccountAdded(this.val$account);
                    }
                }
            });
        }
    }

    final void notifyAccountUpdated(A account) {
        if (!this.observers.isEmpty()) {
            this.mainHandler.post(new Runnable((BaseAccount)account){
                final /* synthetic */ BaseAccount val$account;
                {
                    this.val$account = baseAccount;
                }

                @Override
                public void run() {
                    for (AccountObserver observer : BaseAccountManager.this.observers) {
                        observer.onAccountUpdated(this.val$account);
                    }
                }
            });
        }
    }

    final void notifyAccountRemoved(A account) {
        if (!this.observers.isEmpty()) {
            this.mainHandler.post(new Runnable((BaseAccount)account){
                final /* synthetic */ BaseAccount val$account;
                {
                    this.val$account = baseAccount;
                }

                @Override
                public void run() {
                    for (AccountObserver observer : BaseAccountManager.this.observers) {
                        observer.onAccountRemoved(this.val$account);
                    }
                }
            });
        }
    }

    public final void unregisterObserver(@NonNull AccountObserver<A> observer) {
        this.observers.remove(observer);
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    @NonNull
    public AccountResult addAccount(@NonNull A account) {
        AccountResult result = this.onAddAccount(account);
        if (result.isSuccess()) {
            this.notifyAccountAdded(account);
        }
        return result;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    @NonNull
    protected AccountResult onAddAccount(@NonNull A account) {
        if (this.findSystemAccount(((BaseAccount)account).getName()) != null) {
            return AccountResults.createSuccess();
        }
        Account systemAccount = new Account(((BaseAccount)account).getName(), this.getAccountType());
        if (this.systemManager.addAccountExplicitly(systemAccount, this.encrypt(((BaseAccount)account).getPassword()), this.encryptBundle(((BaseAccount)account).getDataBundle()))) {
            String[] authTokenTypes = ((BaseAccount)account).getAuthTokenTypes();
            Map<String, String> authTokens = ((BaseAccount)account).getAuthTokens();
            if (authTokenTypes != null && authTokenTypes.length > 0 && authTokens != null && !authTokens.isEmpty()) {
                for (String authTokenType : authTokenTypes) {
                    this.systemManager.setAuthToken(systemAccount, this.encryptKey(authTokenType), this.encrypt(authTokens.get(authTokenType)));
                }
            }
            return AccountResults.createSuccess();
        }
        return AccountResults.createFailure(AccountErrors.create(ERROR_SYSTEM_OPERATION_FAILURE));
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    @NonNull
    public AccountResult updateAccount(@NonNull A account) {
        AccountResult result = this.onUpdateAccount(account);
        if (result.isSuccess()) {
            this.notifyAccountUpdated(account);
        }
        return result;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    @NonNull
    protected AccountResult onUpdateAccount(@NonNull A account) {
        Bundle dataBundle;
        Account systemAccount = this.findSystemAccount(((BaseAccount)account).getName());
        if (systemAccount == null) {
            return AccountResults.createFailure(AccountErrors.create(ERROR_ACCOUNT_DOES_NOT_EXIST));
        }
        this.systemManager.setPassword(systemAccount, this.encrypt(((BaseAccount)account).getPassword()));
        String[] authTokenTypes = ((BaseAccount)account).getAuthTokenTypes();
        Map<String, String> authTokens = ((BaseAccount)account).getAuthTokens();
        if (authTokenTypes != null && authTokenTypes.length > 0 && authTokens != null && !authTokens.isEmpty()) {
            for (String authTokenType : authTokenTypes) {
                this.systemManager.setAuthToken(systemAccount, this.encryptKey(authTokenType), this.encrypt(authTokens.get(authTokenType)));
            }
        }
        if ((dataBundle = ((BaseAccount)account).getDataBundle()) != null) {
            for (String key : dataBundle.keySet()) {
                this.systemManager.setUserData(systemAccount, this.encryptKey(key), this.encrypt(dataBundle.getString(key)));
            }
        }
        return AccountResults.createSuccess();
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.MANAGE_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    @NonNull
    public AccountResult removeAccount(@NonNull A account) {
        AccountResult result = this.onRemoveAccount(account);
        if (result.isSuccess()) {
            this.notifyAccountRemoved(account);
        }
        return result;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.MANAGE_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    @NonNull
    protected AccountResult onRemoveAccount(@NonNull A account) {
        Account systemAccount = this.findSystemAccount(((BaseAccount)account).getName());
        if (systemAccount == null) {
            return AccountResults.createFailure(AccountErrors.create(ERROR_ACCOUNT_DOES_NOT_EXIST));
        }
        Bundle operationResult = Bundle.EMPTY;
        AccountError error = AccountError.NONE;
        try {
            if (Build.VERSION.SDK_INT >= 22) {
                operationResult = (Bundle)this.systemManager.removeAccount(systemAccount, null, null, null).getResult();
            } else {
                boolean success = (Boolean)this.systemManager.removeAccount(systemAccount, null, null).getResult();
                operationResult = new Bundle();
                operationResult.putBoolean("booleanResult", success);
            }
        }
        catch (AuthenticatorException | OperationCanceledException | IOException e) {
            error = AccountErrors.create(ERROR_SYSTEM_OPERATION_FAILURE, e);
        }
        if (error != AccountError.NONE) {
            return AccountResults.createFailure(error);
        }
        this.systemManager.setPassword(systemAccount, null);
        String[] authTokenTypes = ((BaseAccount)account).getAuthTokenTypes();
        if (authTokenTypes != null && authTokenTypes.length > 0) {
            for (String authTokenType : authTokenTypes) {
                this.systemManager.invalidateAuthToken(systemAccount.type, this.systemManager.peekAuthToken(systemAccount, this.encryptKey(authTokenType)));
            }
        }
        return AccountResults.createSuccess(operationResult);
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean isAccountAuthenticated(@NonNull String accountName, @NonNull String tokenType) {
        Account systemAccount = this.findSystemAccount(accountName);
        if (systemAccount == null) {
            return false;
        }
        return !TextUtils.isEmpty((CharSequence)this.systemManager.peekAuthToken(systemAccount, this.encryptKey(tokenType)));
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public void setAccountAuthToken(@NonNull String accountName, @NonNull String tokenType, @NonNull String token) {
        Account systemAccount = this.findSystemAccount(accountName);
        if (systemAccount != null) {
            this.systemManager.setAuthToken(systemAccount, this.encryptKey(tokenType), this.encrypt(token));
        }
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    @Nullable
    public String peekAccountAuthToken(@NonNull String accountName, @NonNull String tokenType) {
        Account systemAccount = this.findSystemAccount(accountName);
        if (systemAccount == null) {
            return null;
        }
        return this.decrypt(this.systemManager.peekAuthToken(systemAccount, this.encryptKey(tokenType)));
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.MANAGE_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean invalidateAccountAuthToken(@NonNull String accountName, @NonNull String tokenType) {
        Account systemAccount = this.findSystemAccount(accountName);
        if (systemAccount == null) {
            return false;
        }
        String token = this.systemManager.peekAuthToken(systemAccount, this.encryptKey(tokenType));
        if (token == null) {
            return false;
        }
        this.systemManager.invalidateAuthToken(systemAccount.type, token);
        return true;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    protected void setAccountData(@NonNull String accountName, @NonNull String key, @Nullable String value) {
        Account systemAccount = this.findSystemAccount(accountName);
        if (systemAccount == null) {
            return;
        }
        this.systemManager.setUserData(systemAccount, this.encryptKey(key), this.encrypt(value));
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    @Nullable
    protected String getAccountData(@NonNull String accountName, @NonNull String key) {
        Account systemAccount = this.findSystemAccount(accountName);
        if (systemAccount == null) {
            return null;
        }
        return this.decrypt(this.systemManager.getUserData(systemAccount, this.encryptKey(key)));
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    protected void setAccountDataBundle(@NonNull String accountName, @NonNull Bundle values) {
        Account systemAccount = this.findSystemAccount(accountName);
        if (systemAccount == null) {
            return;
        }
        for (String key : values.keySet()) {
            this.systemManager.setUserData(systemAccount, this.encryptKey(key), this.encrypt(values.getString(key)));
        }
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    @Nullable
    protected Bundle getAccountDataBundle(@NonNull String accountName, @NonNull String[] keys) {
        Account systemAccount = this.findSystemAccount(accountName);
        if (systemAccount == null) {
            return null;
        }
        Bundle dataBundle = new Bundle();
        for (String key : keys) {
            dataBundle.putString(key, this.decrypt(this.systemManager.getUserData(systemAccount, this.encryptKey(key))));
        }
        return dataBundle;
    }

    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    @Nullable
    public A findAccount(@NonNull String accountName) {
        Account systemAccount = this.findSystemAccount(accountName);
        if (systemAccount == null) {
            return null;
        }
        return this.onCreateAccountInstance(this.systemManager, systemAccount);
    }

    @NonNull
    protected abstract A onCreateAccountInstance(@NonNull AccountManager var1, @NonNull Account var2);

    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    @Nullable
    protected Account findSystemAccount(@NonNull String accountName) {
        Account[] accounts = this.systemManager.getAccountsByType(this.accountType);
        if (accounts.length > 0) {
            for (Account account : accounts) {
                if (!account.name.equals(accountName)) continue;
                return account;
            }
        }
        return null;
    }

    public static interface AccountObserver<A extends BaseAccount> {
        public void onAccountAdded(@NonNull A var1);

        public void onAccountUpdated(@NonNull A var1);

        public void onAccountRemoved(@NonNull A var1);
    }
}

