/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.account;

import androidx.annotation.NonNull;
import universum.studios.android.officium.account.AccountError;

public final class AccountErrors {
    private AccountErrors() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static AccountError create(@NonNull String code) {
        return AccountErrors.create(code, AccountError.NONE.cause());
    }

    @NonNull
    public static AccountError create(@NonNull String code, @NonNull Throwable cause) {
        return new ErrorImpl(code, cause);
    }

    private static class ErrorImpl
    implements AccountError {
        private final String code;
        private final Throwable cause;

        ErrorImpl(String code, Throwable cause) {
            this.code = code;
            this.cause = cause;
        }

        @Override
        @NonNull
        public String code() {
            return this.code;
        }

        @Override
        @NonNull
        public Throwable cause() {
            return this.cause;
        }

        @NonNull
        public String toString() {
            StringBuilder builder = new StringBuilder(32);
            builder.append(AccountError.class.getSimpleName());
            builder.append("(code: ");
            builder.append(this.code);
            builder.append(", cause: ");
            builder.append(this.cause);
            return builder.append(")").toString();
        }
    }
}

