/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service;

import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import retrofit2.Retrofit;

public class ServiceManager {
    private final HttpUrl baseUrl;
    private final Map<Class<?>, ServicesConfiguration> services = new HashMap(1);

    public ServiceManager(@NonNull String baseUrl) {
        this(HttpUrl.get((String)baseUrl));
    }

    public ServiceManager(@NonNull HttpUrl baseUrl) {
        this.baseUrl = baseUrl;
    }

    @NonNull
    public final HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    @NonNull
    public final <S> S services(@NonNull Class<S> servicesInterface) {
        return this.ensureServicesConfiguration(servicesInterface).services();
    }

    @NonNull
    public final <S> ServicesConfiguration<S> servicesConfiguration(@NonNull Class<S> servicesInterface) {
        return this.ensureServicesConfiguration(servicesInterface);
    }

    @NonNull
    protected final ServicesConfiguration<?>[] getServicesConfigurations() {
        ServicesConfiguration[] configurations = new ServicesConfiguration[this.services.size()];
        this.services.values().toArray(configurations);
        return configurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S> ServicesConfiguration<S> ensureServicesConfiguration(Class<S> servicesInterface) {
        Map<Class<?>, ServicesConfiguration> map = this.services;
        synchronized (map) {
            ServicesConfiguration<S> servicesConfiguration = this.services.get(servicesInterface);
            if (servicesConfiguration == null) {
                servicesConfiguration = this.onCreateServicesConfiguration(servicesInterface);
                this.services.put(servicesInterface, servicesConfiguration);
            }
            return servicesConfiguration;
        }
    }

    @CallSuper
    @NonNull
    protected <S> ServicesConfiguration<S> onCreateServicesConfiguration(@NonNull Class<S> servicesInterface) {
        ServicesConfiguration<S> configuration = new ServicesConfiguration<S>(servicesInterface);
        configuration.retrofitBuilder().baseUrl(this.baseUrl);
        return configuration;
    }

    public static final class ServicesConfiguration<S> {
        private final Retrofit.Builder builder = new Retrofit.Builder();
        private final Class<S> servicesInterface;
        private S services;
        private Retrofit retrofit;
        private volatile boolean changed = true;

        ServicesConfiguration(@NonNull Class<S> servicesInterface) {
            this.servicesInterface = servicesInterface;
        }

        @NonNull
        public Retrofit.Builder retrofitBuilder() {
            return this.builder;
        }

        @NonNull
        public Retrofit retrofit() {
            this.ensureValid();
            return this.retrofit;
        }

        @NonNull
        S services() {
            this.ensureValid();
            return this.services;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ensureValid() {
            if (this.changed) {
                Retrofit.Builder builder = this.builder;
                synchronized (builder) {
                    this.retrofit = this.builder.build();
                    this.services = this.retrofit.create(this.servicesInterface);
                    this.changed = false;
                }
            }
        }

        public void invalidate() {
            this.changed = true;
        }
    }
}

