/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import universum.studios.android.officium.OfficiumLogging;
import universum.studios.android.officium.sync.SyncOperation;
import universum.studios.android.officium.sync.SyncTask;

public abstract class SyncHandler<Request extends SyncTask.Request, Result> {
    private final int taskId;
    private final Class<Request> requestClass;

    protected SyncHandler(int taskId) {
        this.taskId = taskId;
        this.requestClass = null;
    }

    protected SyncHandler(int taskId, @Nullable Class<Request> classOfRequest) {
        this.taskId = taskId;
        this.requestClass = classOfRequest;
    }

    public final int getTaskId() {
        return this.taskId;
    }

    @Nullable
    public final Result handleSync(@NonNull Context context, @NonNull SyncOperation syncOperation) {
        Request syncRequest = this.requestClass == null ? null : (Request)syncOperation.task.getRequest(this.requestClass);
        try {
            return this.onHandleSync(context, syncOperation, syncRequest);
        }
        catch (Exception error) {
            this.onSyncError(context, syncOperation, syncRequest, error);
            return null;
        }
    }

    @Nullable
    protected abstract Result onHandleSync(@NonNull Context var1, @NonNull SyncOperation var2, @Nullable Request var3) throws Exception;

    protected void onSyncError(@NonNull Context context, @NonNull SyncOperation syncOperation, @Nullable Request syncRequest, @NonNull Exception error) {
        OfficiumLogging.e(this.getClass().getSimpleName(), "An error occurred during synchronization handling!", error);
    }
}

