/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.service;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import universum.studios.android.officium.service.BaseServiceObject;

public class ServiceError
extends BaseServiceObject {
    private final Throwable failure;
    private final int errorCode;
    private final ResponseBody errorBody;
    private Converter<ResponseBody, ?> errorBodyConverter;

    public ServiceError(int errorCode, @NonNull ResponseBody errorBody) {
        this.errorCode = errorCode;
        this.errorBody = errorBody;
        this.failure = null;
    }

    public ServiceError(@NonNull Throwable failure) {
        this.errorCode = 0;
        this.errorBody = null;
        this.failure = failure;
    }

    public ServiceError(@NonNull ServiceError other) {
        this.errorCode = other.errorCode;
        this.errorBody = other.errorBody;
        this.failure = other.failure;
        this.errorBodyConverter = other.errorBodyConverter;
    }

    public final boolean isError() {
        return this.errorBody != null;
    }

    public int getErrorCode() {
        if (this.errorBody == null) {
            throw new UnsupportedOperationException("Not an error but a failure!");
        }
        return this.errorCode;
    }

    @NonNull
    public ResponseBody getErrorBody() {
        if (this.errorBody == null) {
            throw new UnsupportedOperationException("Not an error but a failure!");
        }
        return this.errorBody;
    }

    public void setErrorBodyConverter(@Nullable Converter<ResponseBody, ?> converter) {
        this.errorBodyConverter = converter;
    }

    @Nullable
    public <T> T getErrorBodyAs(@NonNull Class<T> classOfT) {
        if (this.errorBody == null) {
            throw new UnsupportedOperationException("Not an error but a failure!");
        }
        if (this.errorBodyConverter == null) {
            throw new IllegalStateException("No error body converter specified!");
        }
        Object errorBody = null;
        try {
            errorBody = this.errorBodyConverter.convert((Object)this.errorBody);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Specified class(" + classOfT + ") does not match that specified for converter!", e);
        }
        finally {
            this.errorBody.close();
        }
        return (T)errorBody;
    }

    public final boolean isFailure() {
        return this.failure != null;
    }

    @NonNull
    public Throwable getFailure() {
        if (this.failure == null) {
            throw new UnsupportedOperationException("Not a failure but an error!");
        }
        return this.failure;
    }

    public String toString() {
        boolean isFailure = this.isFailure();
        StringBuilder builder = new StringBuilder(64);
        builder.append(this.getClass().getSimpleName());
        builder.append("{isFailure: ");
        builder.append(isFailure);
        builder.append(", errorCode: ");
        builder.append(isFailure ? "NONE" : Integer.valueOf(this.errorCode));
        builder.append(", errorBody: ");
        builder.append((Object)(isFailure ? "NONE" : this.errorBody));
        builder.append(", failure: ");
        builder.append(isFailure ? this.failure : "NONE");
        return builder.append("}").toString();
    }
}

