/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.account;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import universum.studios.android.crypto.Crypto;
import universum.studios.android.crypto.Decrypto;
import universum.studios.android.crypto.Encrypto;
import universum.studios.android.crypto.util.CryptographyUtils;
import universum.studios.android.officium.OfficiumLogging;
import universum.studios.android.officium.account.UserAccount;
import universum.studios.android.util.ErrorException;

public abstract class UserAccountManager<A extends UserAccount> {
    private static final String TAG = "UserAccountManager";
    public static final int ERROR_CREATE_ACCOUNT = -1;
    public static final int ERROR_DELETE_ACCOUNT = -2;
    public static final String PERMISSION_GET_ACCOUNTS = "android.permission.GET_ACCOUNTS";
    public static final String PERMISSION_MANAGE_ACCOUNTS = "android.permission.MANAGE_ACCOUNTS";
    public static final String PERMISSION_AUTHENTICATE_ACCOUNTS = "android.permission.AUTHENTICATE_ACCOUNTS";
    @Deprecated
    @NonNull
    protected final AccountManager systemManager;
    @NonNull
    private final Context context;
    @NonNull
    final String accountType;
    private final Handler mUiHandler;
    private final List<AccountWatcher<A>> mWatchers = new ArrayList<AccountWatcher<A>>();
    private Crypto dataCrypto;
    private Encrypto dataKeyEncrypto;

    public UserAccountManager(@NonNull Context context, @NonNull String accountType) {
        this.systemManager = AccountManager.get((Context)context);
        this.context = context;
        this.accountType = accountType;
        this.mUiHandler = new Handler(Looper.getMainLooper());
    }

    @NonNull
    public final Context getContext() {
        return this.context;
    }

    @NonNull
    public final String getAccountType() {
        return this.accountType;
    }

    @NonNull
    protected final AccountManager getSystemManager() {
        return this.systemManager;
    }

    public final void setDataCrypto(@Nullable Crypto crypto) {
        this.dataCrypto = crypto;
    }

    @Deprecated
    public final void setKeyEncrypto(@Nullable Encrypto encrypto) {
        this.setDataKeyEncrypto(encrypto);
    }

    public final void setDataKeyEncrypto(@Nullable Encrypto encrypto) {
        this.dataKeyEncrypto = encrypto;
    }

    private Bundle encryptBundle(Bundle bundle) {
        if (bundle == null || bundle.isEmpty()) {
            return bundle;
        }
        Set keys = bundle.keySet();
        for (String key : keys) {
            bundle.putString(this.encryptKey(key), this.encryptData(bundle.getString(key)));
        }
        return bundle;
    }

    private String encryptKey(String key) {
        return this.dataKeyEncrypto == null ? key : CryptographyUtils.encrypt((String)key, (Encrypto)this.dataKeyEncrypto);
    }

    @NonNull
    protected final String encryptData(@NonNull String value) {
        return this.dataCrypto == null ? value : CryptographyUtils.encrypt((String)value, (Encrypto)this.dataCrypto);
    }

    @NonNull
    protected final String decryptData(@NonNull String value) {
        return this.dataCrypto == null ? value : CryptographyUtils.decrypt((String)value, (Decrypto)this.dataCrypto);
    }

    public void registerWatcher(@NonNull AccountWatcher<A> watcher) {
        if (!this.mWatchers.contains(watcher)) {
            this.mWatchers.add(watcher);
        }
    }

    public void unregisterWatcher(@NonNull AccountWatcher<A> watcher) {
        this.mWatchers.remove(watcher);
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public void createAccountAsync(@NonNull A userAccount) {
        new CreateAccountTask().execute(new UserAccount[]{userAccount});
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean createAccount(@NonNull A userAccount) {
        if (this.onCreateAccount(userAccount)) {
            this.mUiHandler.post(new Runnable((UserAccount)userAccount){
                final /* synthetic */ UserAccount val$userAccount;
                {
                    this.val$userAccount = userAccount;
                }

                @Override
                public void run() {
                    UserAccountManager.this.notifyAccountCreated(this.val$userAccount);
                }
            });
            return true;
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    protected boolean onCreateAccount(@NonNull A userAccount) {
        Account account = new Account(((UserAccount)userAccount).getName(), this.accountType);
        this.onDeleteAccount(userAccount);
        if (this.systemManager.addAccountExplicitly(account, this.encryptData(((UserAccount)userAccount).getPassword()), this.encryptBundle(((UserAccount)userAccount).getDataBundle()))) {
            String[] authTokenTypes = ((UserAccount)userAccount).getAuthTokenTypes();
            Map<String, String> authTokens = ((UserAccount)userAccount).getAuthTokens();
            if (authTokenTypes != null && authTokenTypes.length > 0 && authTokens != null && !authTokens.isEmpty()) {
                for (String authTokenType : authTokenTypes) {
                    this.systemManager.setAuthToken(account, authTokenType, authTokens.get(authTokenType));
                }
            }
        }
        return true;
    }

    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public void setAccountAuthToken(@NonNull Account account, @NonNull String authTokenType, @Nullable String authToken) {
        this.systemManager.setAuthToken(account, authTokenType, authToken);
    }

    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public boolean isAccountAuthenticated(@NonNull Account account, @NonNull String authTokenType) {
        return !TextUtils.isEmpty((CharSequence)this.peekAccountAuthToken(account, authTokenType));
    }

    @Nullable
    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public String peekAccountAuthToken(@NonNull Account account, @NonNull String authTokenType) {
        return this.systemManager.peekAuthToken(account, authTokenType);
    }

    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public void invalidateAccountAuthToken(@NonNull Account account, @NonNull String authToken) {
        this.systemManager.invalidateAuthToken(account.type, authToken);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public void setAccountPassword(@NonNull Account account, @Nullable String password) {
        this.systemManager.setPassword(account, this.encryptData(password));
    }

    @Deprecated
    @Nullable
    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    public String getAccountPassword(@NonNull Account account) {
        return this.decryptData(this.systemManager.getPassword(account));
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public void clearAccountPassword(@NonNull Account account) {
        this.systemManager.clearPassword(account);
    }

    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    protected void setAccountData(@NonNull Account account, @NonNull String key, @Nullable String value) {
        this.systemManager.setUserData(account, this.encryptKey(key), this.encryptData(value));
    }

    @Nullable
    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    protected String getAccountData(@NonNull Account account, @NonNull String key) {
        return this.decryptData(this.systemManager.getUserData(account, this.encryptKey(key)));
    }

    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    protected void setAccountDataBundle(@NonNull Account account, @NonNull Bundle dataBundle) {
        if (dataBundle.isEmpty()) {
            return;
        }
        for (String key : dataBundle.keySet()) {
            String data = dataBundle.getString(key);
            if (data == null) continue;
            this.systemManager.setUserData(account, this.encryptKey(key), this.encryptData(data));
        }
    }

    @NonNull
    @RequiresPermission(value="android.permission.AUTHENTICATE_ACCOUNTS")
    protected Bundle getAccountDataBundle(@NonNull Account account, String ... keys) {
        Bundle bundle = new Bundle();
        if (keys.length > 0) {
            for (String key : keys) {
                String data = this.systemManager.getUserData(account, this.encryptKey(key));
                if (data == null) continue;
                bundle.putString(key, this.decryptData(data));
            }
        }
        return bundle;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public void deleteAccountAsync(@NonNull A userAccount) {
        new DeleteAccountTask().execute(new UserAccount[]{userAccount});
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    public boolean deleteAccount(@NonNull A userAccount) {
        if (this.onDeleteAccount(userAccount)) {
            this.mUiHandler.post(new Runnable((UserAccount)userAccount){
                final /* synthetic */ UserAccount val$userAccount;
                {
                    this.val$userAccount = userAccount;
                }

                @Override
                public void run() {
                    UserAccountManager.this.notifyAccountDeleted(this.val$userAccount);
                }
            });
            return true;
        }
        return false;
    }

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.AUTHENTICATE_ACCOUNTS"})
    protected boolean onDeleteAccount(@NonNull A userAccount) {
        Account account = this.findAccountForUser(userAccount);
        if (account != null) {
            boolean removed = false;
            try {
                removed = Build.VERSION.SDK_INT >= 22 ? this.systemManager.removeAccount(account, null, null, null).getResult() != null : (Boolean)this.systemManager.removeAccount(account, null, null).getResult();
            }
            catch (AuthenticatorException | OperationCanceledException | IOException e) {
                OfficiumLogging.e(TAG, "Failed to remove account via framework's account manager.", e);
            }
            if (!removed) {
                return false;
            }
            this.systemManager.setPassword(account, null);
            String[] authTokenTypes = ((UserAccount)userAccount).getAuthTokenTypes();
            if (authTokenTypes != null && authTokenTypes.length > 0) {
                for (String authTokenType : authTokenTypes) {
                    this.systemManager.invalidateAuthToken(account.type, this.systemManager.peekAuthToken(account, authTokenType));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    @RequiresPermission(value="android.permission.GET_ACCOUNTS")
    protected Account findAccountForUser(@NonNull A userAccount) {
        Account[] accounts = this.systemManager.getAccountsByType(this.accountType);
        if (accounts.length > 0) {
            String accountName = ((UserAccount)userAccount).getName();
            for (Account account : accounts) {
                if (!account.name.equals(accountName)) continue;
                return account;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyAccountCreated(@NonNull A userAccount) {
        List<AccountWatcher<A>> list = this.mWatchers;
        synchronized (list) {
            if (!this.mWatchers.isEmpty()) {
                for (AccountWatcher<A> watcher : this.mWatchers) {
                    watcher.onAccountCreated(userAccount);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyAccountDeleted(@NonNull A userAccount) {
        List<AccountWatcher<A>> list = this.mWatchers;
        synchronized (list) {
            if (!this.mWatchers.isEmpty()) {
                for (AccountWatcher<A> watcher : this.mWatchers) {
                    watcher.onAccountDeleted(userAccount);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyAccountError(@NonNull A userAccount, @NonNull ErrorException error) {
        List<AccountWatcher<A>> list = this.mWatchers;
        synchronized (list) {
            if (!this.mWatchers.isEmpty()) {
                for (AccountWatcher<A> watcher : this.mWatchers) {
                    watcher.onAccountError(userAccount, error);
                }
            }
        }
    }

    private static final class TaskResult<A extends UserAccount> {
        final A account;
        final ErrorException error;

        TaskResult(A account, ErrorException error) {
            this.account = account;
            this.error = error;
        }
    }

    private final class DeleteAccountTask
    extends AsyncTask<A, Void, TaskResult<A>> {
        private DeleteAccountTask() {
        }

        @SafeVarargs
        protected final TaskResult<A> doInBackground(A ... accounts) {
            Object account = accounts[0];
            ErrorException error = null;
            try {
                if (!UserAccountManager.this.onDeleteAccount(account)) {
                    error = ErrorException.withCode((int)-2);
                }
            }
            catch (Exception e) {
                error = new ErrorException(-2, (Throwable)e);
            }
            return new TaskResult(account, error);
        }

        protected void onPostExecute(@NonNull TaskResult<A> result) {
            if (result.error == null) {
                UserAccountManager.this.notifyAccountDeleted(result.account);
            } else {
                UserAccountManager.this.notifyAccountError(result.account, result.error);
            }
        }
    }

    private final class CreateAccountTask
    extends AsyncTask<A, Void, TaskResult<A>> {
        private CreateAccountTask() {
        }

        @SafeVarargs
        protected final TaskResult<A> doInBackground(A ... accounts) {
            Object account = accounts[0];
            ErrorException error = null;
            try {
                if (!UserAccountManager.this.onCreateAccount(account)) {
                    error = ErrorException.withCode((int)-1);
                }
            }
            catch (Exception e) {
                error = new ErrorException(-1, (Throwable)e);
            }
            return new TaskResult(account, error);
        }

        protected void onPostExecute(@NonNull TaskResult<A> result) {
            if (result.error == null) {
                UserAccountManager.this.notifyAccountCreated(result.account);
            } else {
                UserAccountManager.this.notifyAccountError(result.account, result.error);
            }
        }
    }

    public static interface AccountWatcher<A extends UserAccount> {
        public void onAccountCreated(@NonNull A var1);

        public void onAccountDeleted(@NonNull A var1);

        public void onAccountError(@NonNull A var1, @NonNull ErrorException var2);
    }
}

