/*
 * Decompiled with CFR 0.152.
 */
package universum.studios.android.officium.sync;

import android.accounts.Account;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.Context;
import android.content.SyncResult;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.util.SparseArray;
import universum.studios.android.officium.OfficiumLogging;
import universum.studios.android.officium.sync.OnSyncTaskStateChangeListener;
import universum.studios.android.officium.sync.SyncEvent;
import universum.studios.android.officium.sync.SyncHandler;
import universum.studios.android.officium.sync.SyncOperation;
import universum.studios.android.officium.sync.SyncTask;

public abstract class BaseSyncAdapter
extends AbstractThreadedSyncAdapter {
    private static final String TAG = "BaseSyncAdapter";
    private OnSyncTaskStateChangeListener taskStateChangeListener;
    private EventDispatcher eventDispatcher;
    private SyncHandler globalSyncHandler;
    private SparseArray<SyncHandler> taskHandlers;

    public BaseSyncAdapter(@NonNull Context context, boolean autoInitialize) {
        this(context, autoInitialize, false);
    }

    public BaseSyncAdapter(@NonNull Context context, boolean autoInitialize, boolean allowParallelSyncs) {
        super(context, autoInitialize, allowParallelSyncs);
    }

    protected final void setOnTaskStateChangeListener(@Nullable OnSyncTaskStateChangeListener listener) {
        this.taskStateChangeListener = listener;
    }

    protected final void setEventDispatcher(@Nullable EventDispatcher dispatcher) {
        this.eventDispatcher = dispatcher;
    }

    @Nullable
    protected final EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    protected void setGlobalSyncHandler(@Nullable SyncHandler handler) {
        this.globalSyncHandler = handler;
    }

    @Nullable
    protected SyncHandler getGlobalSyncHandler() {
        return this.globalSyncHandler;
    }

    protected void registerTaskHandler(@NonNull SyncHandler handler) {
        if (this.taskHandlers == null) {
            this.taskHandlers = new SparseArray();
        }
        this.taskHandlers.append(handler.getTaskId(), (Object)handler);
    }

    protected void unregisterTaskHandler(@NonNull SyncHandler handler) {
        if (this.taskHandlers != null && this.taskHandlers.size() > 0) {
            this.taskHandlers.remove(handler.getTaskId());
        }
    }

    public void onPerformSync(@NonNull Account account, @NonNull Bundle extras, @NonNull String authority, @NonNull ContentProviderClient providerClient, @NonNull SyncResult syncResult) {
        SyncOperation syncOperation = new SyncOperation.Builder().account(account).authority(authority).task(this.createTaskFromExtras(extras)).build();
        this.changeTaskStateToAndNotify(syncOperation, 2);
        if (syncOperation.task.getId() == 0) {
            this.onPerformGlobalSync(syncOperation);
        } else {
            this.onPerformSync(syncOperation);
        }
    }

    @NonNull
    protected SyncTask createTaskFromExtras(@NonNull Bundle extras) {
        return new SyncTask(extras);
    }

    protected void onPerformGlobalSync(@NonNull SyncOperation syncOperation) {
        if (this.globalSyncHandler == null) {
            OfficiumLogging.w(TAG, "No global synchronization handler found. Skipping synchronization.");
            return;
        }
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(1).account(syncOperation.account).build());
        try {
            this.globalSyncHandler.handleSync(this.getContext(), syncOperation);
            this.changeTaskStateToAndNotify(syncOperation, 3);
            this.onGlobalSyncFinished(syncOperation);
        }
        catch (Exception error) {
            this.changeTaskStateToAndNotify(syncOperation, 4);
            this.onGlobalSyncFailed(syncOperation, error);
        }
    }

    protected void onGlobalSyncFinished(@NonNull SyncOperation syncOperation) {
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(3).account(syncOperation.account).build());
    }

    protected void onGlobalSyncFailed(@NonNull SyncOperation syncOperation, @NonNull Exception error) {
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(4).account(syncOperation.account).error(error).build());
    }

    protected void onPerformSync(@NonNull SyncOperation syncOperation) {
        SyncHandler taskHandler;
        SyncHandler syncHandler = taskHandler = this.taskHandlers == null ? null : (SyncHandler)this.taskHandlers.get(syncOperation.task.getId());
        if (taskHandler == null) {
            OfficiumLogging.e(TAG, "No synchronization handler found for task with id(" + syncOperation.task.getId() + "). Skipping synchronization.");
            return;
        }
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(1).account(syncOperation.account).build());
        try {
            taskHandler.handleSync(this.getContext(), syncOperation);
            this.changeTaskStateToAndNotify(syncOperation, 3);
            this.onSyncFinished(syncOperation);
        }
        catch (Exception error) {
            this.changeTaskStateToAndNotify(syncOperation, 4);
            this.onSyncFailed(syncOperation, error);
        }
    }

    protected void onSyncFinished(@NonNull SyncOperation syncOperation) {
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(3).account(syncOperation.account).build());
    }

    protected void onSyncFailed(@NonNull SyncOperation syncOperation, @NonNull Exception error) {
        this.dispatchSyncEvent(new SyncEvent.Builder(syncOperation.task.getId()).type(4).account(syncOperation.account).error(error).build());
    }

    @VisibleForTesting
    void changeTaskStateToAndNotify(SyncOperation syncOperation, int state) {
        if (syncOperation.task.getState() != state) {
            syncOperation.task.setState(state);
            if (this.taskStateChangeListener != null) {
                this.taskStateChangeListener.onSyncTaskStateChanged(syncOperation.task, syncOperation.account);
            }
        }
    }

    protected void dispatchSyncEvent(@NonNull Object event) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.dispatch(event);
        }
    }

    public static interface EventDispatcher {
        public void dispatch(@NonNull Object var1);
    }
}

